/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java.proxy.dynamic;

import com.google.common.collect.Maps;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import me.magicall.support.exception.UnknownException;
import me.magicall.support.lang.java.BeanKit;
import me.magicall.support.lang.java.EnhancedField;
import me.magicall.support.lang.java.MethodKit;
import me.magicall.support.lang.java.ObjKit;

public class MapBeanInvocationHandler
implements InvocationHandler {
    private final Map<String, Object> fields;

    public MapBeanInvocationHandler() {
        this(Maps.newHashMap());
    }

    public MapBeanInvocationHandler(Map<String, Object> fields) {
        this.fields = fields;
    }

    @Override
    public final Object invoke(Object obj, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (BeanKit.isSetter(method, false)) {
            this.set(BeanKit.setterNameToFieldName(method.getName()), args[0]);
            return null;
        }
        if (BeanKit.isGetter(method)) {
            String fieldName = BeanKit.getterToFieldName(method);
            if (this.fields.containsKey(fieldName)) {
                return this.get(fieldName);
            }
            if (method.isDefault()) {
                return MapBeanInvocationHandler.invokeDefaultMethod(obj, method);
            }
            this.set(fieldName, null);
            return null;
        }
        if (MethodKit.isHashCode(method)) {
            return this.invokeHashCode();
        }
        if (MethodKit.isTheEquals(method)) {
            return this.invokeEquals(method, args);
        }
        if (MethodKit.isToString(method)) {
            return this.invokeToString(method, args);
        }
        return this.invokeOther(method, args);
    }

    protected Object invokeOther(Method method, Object ... args) throws IllegalAccessException, InvocationTargetException {
        return this.invokeMyself(method, args);
    }

    protected Object invokeToString(Method method, Object ... args) throws InvocationTargetException, IllegalAccessException {
        return this.invokeMyself(method, args);
    }

    protected Object invokeEquals(Method method, Object ... args) throws InvocationTargetException, IllegalAccessException {
        return this.invokeMyself(method, args);
    }

    protected Object invokeHashCode() {
        return this.fields.hashCode();
    }

    protected final Object invokeMyself(Method method, Object ... args) throws IllegalAccessException, InvocationTargetException {
        return method.invoke((Object)this, args);
    }

    private static Object invokeDefaultMethod(Object obj, Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        MethodHandles.Lookup lookup = MethodHandles.publicLookup().in(declaringClass);
        MapBeanInvocationHandler.hackLookup(lookup);
        try {
            return lookup.unreflectSpecial(method, declaringClass).bindTo(obj).invokeWithArguments(new Object[0]);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new UnknownException(throwable);
        }
    }

    private static void hackLookup(MethodHandles.Lookup lookup) {
        try {
            Field f = MethodHandles.Lookup.class.getDeclaredField("allowedModes");
            EnhancedField enhancedAllowedModes = EnhancedField.of(f);
            enhancedAllowedModes.setAccessible();
            f.set(lookup, 2);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            throw new UnknownException(e);
        }
    }

    public final void set(String fieldName, Object value) {
        this.fields.put(fieldName, value);
    }

    public final Object get(String fieldName) {
        return this.fields.get(fieldName);
    }

    public final Map<String, Object> toMap() {
        return new LinkedHashMap<String, Object>(this.fields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.fields.forEach((k, v) -> sb.append(ObjKit.deepToString(k)).append('=').append(ObjKit.deepToString(v)).append(','));
        int length = sb.length();
        int last = length - 1;
        if (length > 0 && sb.charAt(last) == ',') {
            sb.deleteCharAt(last);
        }
        return sb.toString();
    }
}

