/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java.runtime;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import me.magicall.support.lang.java.runtime.VirtualJavaClassFile;

class SourceCodeFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final Map<String, VirtualJavaClassFile> nameClassFileMap = Maps.newHashMap();
    private final SourceCodeClassLoader sourceCodeClassLoader = new SourceCodeClassLoader();

    SourceCodeFileManager(JavaFileManager raw) {
        super(raw);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.sourceCodeClassLoader;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
        VirtualJavaClassFile classFile = new VirtualJavaClassFile(className, kind);
        this.nameClassFileMap.put(className, classFile);
        return classFile;
    }

    private class SourceCodeClassLoader
    extends ClassLoader {
        private SourceCodeClassLoader() {
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            VirtualJavaClassFile classFile = SourceCodeFileManager.this.nameClassFileMap.get(name);
            if (classFile == null) {
                throw new ClassNotFoundException();
            }
            byte[] b = classFile.toBytes();
            return this.defineClass(name, b, 0, b.length);
        }
    }
}

