/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java.runtime;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.time.Instant;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

class VirtualJavaClassFile
extends SimpleJavaFileObject {
    private final Instant lastModified = Instant.now();
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    VirtualJavaClassFile(String className, JavaFileObject.Kind kind) {
        super(URI.create("string:///" + className.replace('.', '/') + kind.extension), kind);
    }

    public byte[] toBytes() {
        return this.outputStream.toByteArray();
    }

    @Override
    public OutputStream openOutputStream() {
        return this.outputStream;
    }

    @Override
    public long getLastModified() {
        return this.lastModified.getEpochSecond();
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        return this.outputStream.toString();
    }
}

