/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.regex;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface Patterns {
    public static final Pattern NUM_PATTERN = Pattern.compile("\\d+");
    public static final Pattern COMMA_PATTERN = Pattern.compile(",");
    public static final Pattern SPACES_PATTERN = Pattern.compile("\\s+");
    public static final Pattern PATH_PATTERN = Pattern.compile("/");
    public static final Pattern HYPHEN_PATTERN = Pattern.compile("-");
    public static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    public static final Pattern REGEX_GROUP_NAME_PATTERN = Pattern.compile("\\(\\?<([^>]+)>.*?\\)");

    public static String[] commaSplit(String s) {
        return COMMA_PATTERN.split(s);
    }

    public static String[] hyphenSplit(String s) {
        return HYPHEN_PATTERN.split(s);
    }

    public static String[] dotSplit(String s) {
        return DOT_PATTERN.split(s);
    }

    public static String[] spaceSplit(String s) {
        return SPACES_PATTERN.split(s);
    }

    public static List<String> groupNamesIn(Pattern pattern) {
        String patternStr = pattern.pattern();
        LinkedList groupNames = Lists.newLinkedList();
        Matcher patternMeta = REGEX_GROUP_NAME_PATTERN.matcher(patternStr);
        while (patternMeta.find()) {
            groupNames.add(patternMeta.group(1));
        }
        return groupNames;
    }
}

