/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.locale.\u4e2d\u56fd\u901a.\u6570\u5b66;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public enum ChineseDigit {
    \u3007('\u96f6', 0L),
    \u4e00('\u58f9', 1L),
    \u4e8c('\u8d30', 2L),
    \u4e09('\u53c1', 3L),
    \u56db('\u8086', 4L),
    \u4e94('\u4f0d', 5L),
    \u516d('\u9646', 6L),
    \u4e03('\u67d2', 7L),
    \u516b('\u634c', 8L),
    \u4e5d('\u7396', 9L),
    \u5341('\u62fe', 10L),
    \u767e('\u4f70', 100L),
    \u5343('\u4edf', 1000L),
    \u4e07('\u4e07', 10000L),
    \u4ebf('\u4ebf', 10000000L);

    public final char lowerCaseChar = this.name().charAt(0);
    public final String lowerCase = this.name();
    public final char upperCaseChar;
    public final String upperCase;
    public final long num;
    public static final Pattern CHINESE_NUM_SEQUENCE_PATTER;

    private ChineseDigit(char upperCaseChar, long num) {
        this.upperCaseChar = upperCaseChar;
        this.upperCase = String.valueOf(upperCaseChar);
        this.num = num;
    }

    public long toNum() {
        return this.num;
    }

    public static boolean isChineseDigit(char c) {
        return Arrays.stream(ChineseDigit.values()).map(e -> Character.valueOf(e.lowerCaseChar)).anyMatch(e -> e.charValue() == c);
    }

    public static boolean isChineseNumSequence(String s) {
        return CHINESE_NUM_SEQUENCE_PATTER.matcher(s).matches();
    }

    public static ChineseDigit of(char c) {
        return Arrays.stream(ChineseDigit.values()).filter(value -> c == value.lowerCaseChar || c == value.upperCaseChar).findFirst().orElse(null);
    }

    public static ChineseDigit of(String s) {
        return Arrays.stream(ChineseDigit.values()).filter(value -> s.equals(value.lowerCase) || s.equals(value.upperCase)).findFirst().orElse(null);
    }

    public static String toUpperCase(String s) {
        String rt = s;
        for (ChineseDigit digit : ChineseDigit.values()) {
            rt = rt.replace(digit.upperCaseChar, digit.lowerCaseChar);
        }
        return rt;
    }

    public static String toLowerCase(String s) {
        String rt = s;
        for (ChineseDigit digit : ChineseDigit.values()) {
            rt = rt.replace(digit.lowerCaseChar, digit.upperCaseChar);
        }
        return rt;
    }

    static {
        ChineseDigit[] values = ChineseDigit.values();
        HashSet chars = Sets.newHashSet();
        Arrays.stream(values).forEach(value -> {
            chars.add(Character.valueOf(value.lowerCaseChar));
            chars.add(Character.valueOf(value.upperCaseChar));
        });
        String sb = chars.stream().map(String::valueOf).collect(Collectors.joining());
        CHINESE_NUM_SEQUENCE_PATTER = Pattern.compile("[" + sb + "]+");
    }
}

