/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.locale.\u4e2d\u56fd\u901a.\u6570\u5b66;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import me.magicall.support.lang.java.CharKit;
import me.magicall.support.locale.\u4e2d\u56fd\u901a.\u6570\u5b66.BigUnitMode;
import me.magicall.support.locale.\u4e2d\u56fd\u901a.\u6570\u5b66.CaseMode;
import me.magicall.support.locale.\u4e2d\u56fd\u901a.\u6570\u5b66.ChineseDigit;
import me.magicall.support.locale.\u4e2d\u56fd\u901a.\u6570\u5b66.ThirtyMode;
import me.magicall.support.locale.\u4e2d\u56fd\u901a.\u6570\u5b66.TwentyMode;
import me.magicall.support.locale.\u4e2d\u56fd\u901a.\u6570\u5b66.TwoMode;

public class ChineseNumParser {
    public static final String NEGATIVE_SIGN = "\u8d1f";
    public static final String POSITIVE_SIGN = "\u6b63";
    public static final String POINT = "\u70b9";
    private static final String[] SMALL_GROUP_UNITS = new String[]{"", "\u5341", "\u767e", "\u5343"};
    private static final int GROUP_BIT_THRESHOLD = 4;
    private static final int SMALL_GROUP_MAX_LEN = 7;
    private boolean use\u3007InLowerCase = true;
    private TwoMode twoMode = TwoMode.\u4e8c;
    private TwentyMode twentyMode = TwentyMode.\u4e8c\u5341;
    private ThirtyMode thirtyMode = ThirtyMode.\u4e09\u5341;
    private BigUnitMode bigUnitMode = BigUnitMode.\u4ebf\u4ebf;
    private CaseMode caseMode = CaseMode.\u5c0f\u5199;
    private boolean upperCase;

    public String digitParse(long num) {
        long numToUse;
        boolean negative;
        if (num == 0L) {
            return this.say0();
        }
        if (num < 0L) {
            negative = true;
            numToUse = num == Long.MIN_VALUE ? Long.MAX_VALUE : -num;
        } else {
            negative = false;
            numToUse = num;
        }
        StringBuilder sb = new StringBuilder();
        LongStream.iterate(numToUse, n -> n != 0L, n -> n / 10L).map(n -> n % 10L).forEach(mod -> {
            if (mod == 0L) {
                sb.append(this.use\u3007InLowerCase ? ChineseDigit.\u3007.lowerCaseChar : ChineseDigit.\u3007.upperCaseChar);
            } else {
                sb.append(ChineseDigit.values()[(int)mod].lowerCaseChar);
            }
        });
        if (negative) {
            sb.append(NEGATIVE_SIGN);
        }
        if (num == Long.MIN_VALUE) {
            sb.replace(0, 1, ChineseDigit.\u516b.name());
        }
        return sb.reverse().toString();
    }

    public String parse(long num) {
        if (num == 0L) {
            return this.say0();
        }
        String parsed = this.digitParse(num);
        String digitStr = num < 0L ? parsed.substring(1) : parsed;
        ArrayList bigGroups = Lists.newArrayList();
        SmallGroup lastGroup = null;
        BigGroup curBigGroup = null;
        String s = digitStr;
        while (!s.isEmpty()) {
            int last4BitIndex = Math.max(0, s.length() - 4);
            SmallGroup smallGroup = new SmallGroup(s.substring(last4BitIndex));
            if (lastGroup == null) {
                lastGroup = smallGroup;
            } else if (curBigGroup == null) {
                curBigGroup = new BigGroup();
                curBigGroup.set\u4e07Group(smallGroup);
            } else {
                curBigGroup.set\u4ebfGroup(smallGroup);
                bigGroups.add(curBigGroup);
                curBigGroup = null;
            }
            s = s.substring(0, last4BitIndex);
        }
        if (curBigGroup != null) {
            bigGroups.add(curBigGroup);
        }
        StringBuilder sb = new StringBuilder();
        IntStream.iterate(bigGroups.size() - 1, i -> i >= 0, i -> i - 1).mapToObj(i -> ((BigGroup)bigGroups.get(i)).toCnNum()).forEach(sb::append);
        assert (lastGroup != null);
        sb.append((CharSequence)lastGroup.toCnNum());
        if (sb.charAt(0) == this.say0Char()) {
            sb.deleteCharAt(0);
        }
        if (num < 0L) {
            sb.insert(0, NEGATIVE_SIGN);
        }
        return sb.toString().replace("\u4ebf\u4e07", "\u4ebf");
    }

    public long parse(String cnNum) {
        String s;
        if (cnNum == null) {
            throw new NumberFormatException("null");
        }
        if (cnNum.isBlank()) {
            throw ChineseNumParser.exception(cnNum);
        }
        StringBuilder sb = new StringBuilder();
        if (cnNum.startsWith(NEGATIVE_SIGN)) {
            s = cnNum.substring(1);
            sb.append('-');
        } else {
            s = cnNum.startsWith(POSITIVE_SIGN) ? cnNum.substring(1) : cnNum;
        }
        String[] smallGroupParts = s.split("[\u4ebf\u4e07]");
        Arrays.stream(smallGroupParts).forEach(smallGroupPart -> this.parseSmallGroupPart(sb, (String)smallGroupPart));
        if (smallGroupParts.length == 1) {
            if (s.contains("\u4ebf")) {
                IntStream.range(0, 8).forEach(i -> sb.append(0));
            } else if (s.contains("\u4e07")) {
                IntStream.range(0, 4).forEach(i -> sb.append(0));
            }
        } else if (smallGroupParts.length == 2 && s.contains("\u4ebf")) {
            if (s.contains("\u4e07")) {
                IntStream.range(0, 4).forEach(i -> sb.append(0));
            } else {
                sb.insert(sb.length() - 4, "0000");
            }
        }
        return Long.parseLong(sb.toString());
    }

    private void parseSmallGroupPart(StringBuilder sb, String smallGroupPart) {
        int addedLen;
        char c1 = smallGroupPart.charAt(0);
        if (c1 == '\u5341') {
            sb.append("001");
            int length = smallGroupPart.length();
            if (length == 1) {
                sb.append(0);
                return;
            }
            if (length > 2) {
                throw ChineseNumParser.exception(smallGroupPart);
            }
            sb.append(ChineseNumParser.toNum(smallGroupPart.charAt(1)));
            return;
        }
        String strToUse = smallGroupPart.replace(this.say0(), "");
        if (strToUse.isEmpty()) {
            sb.append(0);
            return;
        }
        int lenToUse = strToUse.length();
        char[] units = new char[]{'\u5343', '\u767e', '\u5341'};
        int lenAtBeginning = sb.length();
        int startIndex = 0;
        int remainMaxLen = 7;
        for (char unit : units) {
            if (lenToUse - startIndex > remainMaxLen) {
                throw ChineseNumParser.exception(smallGroupPart);
            }
            int unitIndex = startIndex + 1;
            if (unitIndex < lenToUse) {
                if (unit == strToUse.charAt(unitIndex)) {
                    sb.append(ChineseNumParser.toNum(strToUse.charAt(startIndex)));
                    startIndex += 2;
                } else {
                    sb.append(0);
                }
            } else {
                sb.append(0);
            }
            remainMaxLen -= 2;
        }
        if (lenToUse - startIndex > remainMaxLen) {
            throw ChineseNumParser.exception(smallGroupPart);
        }
        char lastChar = strToUse.charAt(lenToUse - 1);
        if (!CharKit.in(lastChar, units)) {
            sb.append(ChineseNumParser.toNum(lastChar));
        }
        if ((addedLen = sb.length() - lenAtBeginning) < 4) {
            sb.append("0".repeat(Math.max(0, 4 - addedLen)));
        }
    }

    private static NumberFormatException exception(String s) {
        return new NumberFormatException("For input string: \"" + s + "\"");
    }

    private static long toNum(char c) {
        String s = String.valueOf(c);
        ChineseDigit digit = ChineseDigit.of(s);
        if (digit == null || digit.compareTo(ChineseDigit.\u4e5d) > 0) {
            throw new NumberFormatException(s);
        }
        return digit.num;
    }

    public String say0() {
        return String.valueOf(this.say0Char());
    }

    private char say0Char() {
        return this.use\u3007InLowerCase ? ChineseDigit.\u3007.lowerCaseChar : ChineseDigit.\u3007.upperCaseChar;
    }

    public String say2() {
        return String.valueOf(this.say2Char());
    }

    private char say2Char() {
        return this.twoMode.name().charAt(0);
    }

    public String say20() {
        return this.twentyMode.name();
    }

    public String say30() {
        return this.thirtyMode.name();
    }

    public TwoMode getTwoMode() {
        return this.twoMode;
    }

    public ChineseNumParser withTwoMode(TwoMode twoMode) {
        this.twoMode = twoMode;
        return this;
    }

    public TwentyMode getTwentyMode() {
        return this.twentyMode;
    }

    public ChineseNumParser withTwentyMode(TwentyMode twentyMode) {
        this.twentyMode = twentyMode;
        return this;
    }

    public ThirtyMode getThirtyMode() {
        return this.thirtyMode;
    }

    public ChineseNumParser withThirtyMode(ThirtyMode thirtyMode) {
        this.thirtyMode = thirtyMode;
        return this;
    }

    public BigUnitMode getBigUnitMode() {
        return this.bigUnitMode;
    }

    public ChineseNumParser withBigUnitMode(BigUnitMode bigUnitMode) {
        this.bigUnitMode = bigUnitMode;
        return this;
    }

    public boolean isUsingUpperCase() {
        return this.upperCase;
    }

    public ChineseNumParser useUpperCase() {
        this.upperCase = true;
        return this;
    }

    public ChineseNumParser useLowerCase() {
        this.upperCase = false;
        return this;
    }

    public boolean isUsing\u3007InLowerCase() {
        return this.use\u3007InLowerCase;
    }

    public ChineseNumParser use\u3007InLowerCase() {
        this.use\u3007InLowerCase = true;
        return this;
    }

    public ChineseNumParser use\u96f6InLowerCase() {
        this.use\u3007InLowerCase = false;
        return this;
    }

    public ChineseNumParser use\u5c0f\u5199() {
        this.caseMode = CaseMode.\u5c0f\u5199;
        return this;
    }

    public ChineseNumParser use\u5927\u5199() {
        this.caseMode = CaseMode.\u5927\u5199;
        return this;
    }

    public CaseMode getCaseMode() {
        return this.caseMode;
    }

    private final class SmallGroup {
        private final String digits;

        private SmallGroup(String digits) {
            this.digits = digits;
        }

        StringBuilder toCnNum() {
            int i2;
            int length = this.digits.length();
            StringBuilder sb = new StringBuilder(7);
            IntStream.range(0, length).forEach(i -> sb.append(this.digits.charAt(i)).append(SMALL_GROUP_UNITS[length - i - 1]));
            for (i2 = 0; i2 < sb.length(); ++i2) {
                int nextIndex;
                if (sb.charAt(i2) != ChineseNumParser.this.say0Char() || (nextIndex = i2 + 1) >= sb.length()) continue;
                sb.deleteCharAt(nextIndex);
            }
            for (i2 = 0; i2 < sb.length(); ++i2) {
                int start;
                int end;
                if (sb.charAt(i2) != ChineseNumParser.this.say0Char()) continue;
                for (end = start = i2 + 1; end < sb.length() && sb.charAt(end) == ChineseNumParser.this.say0Char(); ++end) {
                }
                sb.delete(start, end);
            }
            int lastIndex = sb.length() - 1;
            if (sb.charAt(lastIndex) == ChineseNumParser.this.say0Char()) {
                sb.deleteCharAt(lastIndex);
            }
            return sb;
        }
    }

    private final class BigGroup {
        private SmallGroup \u4ebfGroup;
        private SmallGroup \u4e07Group;

        private BigGroup() {
        }

        private StringBuilder toCnNum() {
            if (this.\u4ebfGroup == null) {
                return this.\u4e07Group.toCnNum().append('\u4e07');
            }
            return this.\u4ebfGroup.toCnNum().append('\u4ebf').append((CharSequence)this.\u4e07Group.toCnNum().append('\u4e07'));
        }

        private void set\u4ebfGroup(SmallGroup group) {
            this.\u4ebfGroup = group;
        }

        private void set\u4e07Group(SmallGroup group) {
            this.\u4e07Group = group;
        }
    }
}

