/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.math;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import me.magicall.support.exception.UnknownException;

public class EncryptKit {
    private static final Pattern MINUS_PATTERN = Pattern.compile("-", 16);
    private static final char[] CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final BigInteger _62 = new BigInteger(String.valueOf(CHARS.length));

    @Deprecated
    public static String uuidToRadix62() {
        return EncryptKit.randomRadix62Uuid();
    }

    public static String randomRadix62Uuid() {
        String uuid = UUID.randomUUID().toString();
        String pureUuid = MINUS_PATTERN.matcher(uuid).replaceAll(Matcher.quoteReplacement(""));
        return EncryptKit.numStrToRadix52(pureUuid);
    }

    public static String toRadix62(long num) {
        return EncryptKit.numStrToRadix52(Long.toHexString(num));
    }

    public static String toRadix62(int num) {
        return EncryptKit.numStrToRadix52(Integer.toHexString(num));
    }

    private static String numStrToRadix52(String pureUuid) {
        StringBuilder sb = new StringBuilder();
        Stream.iterate(new BigInteger(pureUuid, 16), bi -> bi.compareTo(BigInteger.ZERO) > 0, bi -> bi.divide(_62)).map(bi -> bi.mod(_62)).map(mod -> Character.valueOf(CHARS[mod.intValue()])).forEach(sb::append);
        return sb.reverse().toString();
    }

    private static String bytesToStr(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int n : bytes) {
            int i = n;
            if (i < 0) {
                i += 256;
            }
            if (i < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(i));
        }
        return sb.toString();
    }

    public static String md5(String plainText) {
        if (plainText == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] b = md.digest(plainText.getBytes());
            return EncryptKit.bytesToStr(b);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnknownException(e);
        }
    }
}

