/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.relation;

import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.magicall.support.Thing;
import me.magicall.support.exception.OperationNotAvailableException;

@FunctionalInterface
public interface Parent<T> {
    public Stream<? extends T> children();

    default public int countChildren() {
        return (int)this.children().count();
    }

    default public Parent<T> adopt(Stream<? extends T> children) {
        throw new OperationNotAvailableException(OperationNotAvailableException.Operator.UNKNOWN, "adopt", Thing.of("T", children.collect(Collectors.toList()).toString()));
    }

    default public Parent<T> adopt(T ... children) {
        return this.adopt(Stream.of(children));
    }

    default public Parent<T> unshift(Stream<? extends T> children) {
        throw new OperationNotAvailableException(OperationNotAvailableException.Operator.UNKNOWN, "unshift", Thing.of("T", children.collect(Collectors.toList()).toString()));
    }

    default public Parent<T> unshift(T ... children) {
        return this.unshift(Stream.of(children));
    }

    default public Parent<T> dropChildren(Stream<? extends T> children) {
        throw new OperationNotAvailableException(OperationNotAvailableException.Operator.UNKNOWN, "dropChildren", Thing.of("T", children.collect(Collectors.toList()).toString()));
    }

    default public Parent<T> dropChildren(T ... children) {
        return this.dropChildren(Stream.of(children));
    }

    default public Parent<T> setChildren(Stream<? extends T> children) {
        return this.dropChildren(this.children()).adopt(children);
    }

    default public Integer findChildPlace(T maybeChild) {
        return (int)this.children().takeWhile(Predicate.isEqual(maybeChild)).count();
    }

    default public T findChild(T maybeChild) {
        return this.children().filter(Predicate.isEqual(maybeChild)).findFirst().orElse(null);
    }
}

