/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.text;

import java.util.Objects;
import java.util.stream.Stream;
import me.magicall.support.Thing;
import me.magicall.support.exception.OperationNotAvailableException;
import me.magicall.support.relation.Parent;
import me.magicall.support.text.Text;

public interface Fragment
extends Text,
Parent<Fragment> {
    @Override
    default public String content() {
        return this.directContent();
    }

    public String directContent();

    default public Fragment withDirectContent(String directContent) {
        throw new OperationNotAvailableException(OperationNotAvailableException.Operator.UNKNOWN, "withDirectContent", Thing.of("String", directContent));
    }

    default public String fullContent() {
        return this.appendTo(new StringBuilder()).toString();
    }

    default public Text prefix() {
        return null;
    }

    default public Fragment withPrefix(Text prefix) {
        throw new OperationNotAvailableException(OperationNotAvailableException.Operator.UNKNOWN, "withPrefix", Thing.of("Text", prefix.content()));
    }

    default public Text postfix() {
        return null;
    }

    default public Fragment withPostfix(Text postfix) {
        throw new OperationNotAvailableException(OperationNotAvailableException.Operator.UNKNOWN, "withPostfix", Thing.of("Text", postfix.content()));
    }

    @Override
    public Stream<? extends Fragment> children();

    default public StringBuilder appendTo(StringBuilder sb) {
        StringBuilder s = sb;
        s = this.appendPrefix(s);
        s = this.appendDirectContent(s);
        s = this.appendChildren(s);
        s = this.appendPostfix(s);
        return s;
    }

    default public StringBuilder appendChildren(StringBuilder sb) {
        return this.children().reduce(sb, (stringBuilder, c) -> c.appendTo((StringBuilder)stringBuilder), (a, b) -> b);
    }

    default public StringBuilder appendDirectContent(StringBuilder sb) {
        return sb.append(this.directContent());
    }

    default public StringBuilder appendPrefix(StringBuilder sb) {
        Text prefix = this.prefix();
        return prefix == null ? sb : sb.append(prefix.content());
    }

    default public StringBuilder appendPostfix(StringBuilder sb) {
        Text postfix = this.postfix();
        return postfix == null ? sb : sb.append(postfix.content());
    }

    public static String toString(Fragment o) {
        return Text.toString(o);
    }

    public static int hash(Fragment o) {
        return Objects.hash(o.fullContent());
    }

    public static boolean equals(Fragment a, Object b) {
        return Text.equals(a, b) && Objects.equals(a.fullContent(), ((Fragment)b).fullContent());
    }
}

