/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.text;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import me.magicall.support.text.FixedText;
import me.magicall.support.text.TextTechSupport;

@FunctionalInterface
public interface Text
extends Comparable<Text> {
    public static final Text EMPTY = new FixedText("");

    public String content();

    default public long length() {
        return this.content().length();
    }

    default public boolean isBlank() {
        return this.content().isBlank();
    }

    default public boolean isEmpty() {
        return this.content().isEmpty();
    }

    default public Text trim() {
        return Text.of(this.content().strip());
    }

    default public Text trimLeading() {
        return Text.of(this.content().stripLeading());
    }

    default public Text trimTrailing() {
        return Text.of(this.content().stripTrailing());
    }

    default public boolean equalsIgnoreCase(Text other) {
        return this.content().equalsIgnoreCase(other.content());
    }

    default public Text concat(Text ... other) {
        return Text.of(Arrays.stream(other).map(Text::content).collect(Collectors.joining("", this.content(), "")));
    }

    default public Text repeat(int count) {
        return Text.of(this.content().repeat(count));
    }

    default public boolean contains(Text other) {
        return this.content().contains(other.content());
    }

    default public boolean startsWith(Text other) {
        return this.content().startsWith(other.content());
    }

    default public boolean endsWith(Text other) {
        return this.content().endsWith(other.content());
    }

    default public int placeOf(Text other) {
        return this.placeOf(other, TextTechSupport.FIRST_PLACE);
    }

    default public int placeOf(Text other, int fromPlace) {
        return TextTechSupport.offsetToPlace(this.content().indexOf(other.content(), TextTechSupport.placeToOffset(fromPlace)));
    }

    @Override
    default public int compareTo(Text other) {
        return this.content().compareTo(other.content());
    }

    public String toString();

    public static String toString(Text o) {
        return o.content();
    }

    public static int hash(Text o) {
        return Objects.hash(o.content());
    }

    public static boolean equals(Text a, Object b) {
        if (a == b) {
            return true;
        }
        return a != null && b instanceof Text && Objects.equals(a.content(), ((Text)b).content());
    }

    public static Text of(String s) {
        return new FixedText(s);
    }
}

