/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.text;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import me.magicall.support.text.Text;

public interface TextTechSupport {
    public static final int OFFSET_TO_PLACE_DELTA = 1;
    public static final int FIRST_PLACE = TextTechSupport.offsetToPlace(0);
    public static final String LINE_SEPARATOR = "\r\n";
    public static final Comparator<Map.Entry<? extends Text, Integer>> SUB_FRAGMENT_POSITION_COMPARATOR = Map.Entry.comparingByValue().thenComparingLong(e -> ((Text)e.getKey()).length()).thenComparing(Map.Entry::getKey, Comparator.comparing(Object::toString));

    public static Stream<Text> partsMatches(Text text, Pattern pattern) {
        String content = text.content();
        LinkedList rt = Lists.newLinkedList();
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            rt.add(Text.of(content.substring(matcher.start(), matcher.end())));
        }
        return rt.stream();
    }

    public static int placeToOffset(int place) {
        return place - 1;
    }

    public static int offsetToPlace(int offset) {
        return offset + 1;
    }
}

