/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.time;

import java.time.Year;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import me.magicall.support.time.TimeKit;
import me.magicall.support.time.TimeSpan;

@Deprecated
public final class DateTime
extends Date {
    public static final DateTime START = new DateTime(1970, 1, 1);
    private static final long serialVersionUID = 8674981431221127468L;
    private transient Integer myYear;
    private transient Integer myMonth;
    private transient Integer myDate;
    private transient Integer myDay;
    private transient String stringValue;

    public DateTime(long time) {
        super(time);
    }

    public DateTime() {
        this(System.currentTimeMillis());
    }

    public DateTime(Date time) {
        this(time.getTime());
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        this(TimeKit.toMillisecond(year, month, day, hour, minute, second, millisecond));
        this.myYear = year;
        this.myMonth = month;
    }

    public DateTime(int year, int month, int day) {
        this(TimeKit.toMillisecond(year, month, day, 0, 0, 0, 0));
        this.myYear = year;
        this.myMonth = month;
    }

    public static DateTime fromDate(Date date) {
        return date instanceof DateTime ? (DateTime)date : new DateTime(date);
    }

    public static DateTime thisHourStart() {
        return new DateTime(new DateTime().getAllHoursCount());
    }

    public static DateTime thisMinuteStart() {
        return new DateTime(new DateTime().getAllMinutesCount());
    }

    public static void main(String ... args) {
        Date d = new Date(0L);
        DateTime dt = new DateTime(0L);
        System.out.println(d);
        System.out.println(dt);
        System.out.println(d.getTime());
        System.out.println(dt.getTime());
    }

    public boolean isLeapYear() {
        return Year.isLeap(this.getYear());
    }

    public boolean less(DateTime other) {
        return this.getTime() < other.getTime();
    }

    public boolean lessEqual(DateTime other) {
        return this.getTime() <= other.getTime();
    }

    public boolean greate(DateTime other) {
        return this.getTime() > other.getTime();
    }

    public boolean greateEqual(DateTime other) {
        return this.getTime() >= other.getTime();
    }

    public DateTime add(TimeSpan distance) {
        return new DateTime(this.getTime() + distance.getTime());
    }

    public DateTime add(TimeSpan distance1, TimeSpan distance2) {
        return new DateTime(this.getTime() + distance1.getTime() + distance2.getTime());
    }

    public DateTime add(TimeSpan distance1, TimeSpan distance2, TimeSpan distance3) {
        return new DateTime(this.getTime() + distance1.getTime() + distance2.getTime() + distance3.getTime());
    }

    public DateTime add(TimeSpan d1, TimeSpan ... other) {
        return new DateTime(TimeSpan.add(this.getTime(), other));
    }

    public DateTime sub(TimeSpan distance) {
        return new DateTime(this.getTime() - distance.getTime());
    }

    public DateTime sub(TimeSpan distance1, TimeSpan distance2) {
        return new DateTime(this.getTime() - distance1.getTime() - distance2.getTime());
    }

    public DateTime sub(TimeSpan distance1, TimeSpan distance2, TimeSpan distance3) {
        return new DateTime(this.getTime() - distance1.getTime() - distance2.getTime() - distance3.getTime());
    }

    public DateTime sub(TimeSpan d1, TimeSpan ... distances) {
        return new DateTime(TimeSpan.sub(this.getTime(), distances));
    }

    public TimeSpan sub(DateTime otherPoint) {
        return new TimeSpan(this.getTime() - otherPoint.getTime());
    }

    public boolean isTheSameDayWith(Date otherDay, boolean escapeYear) {
        DateTime other;
        DateTime dateTime = other = otherDay instanceof DateTime ? (DateTime)otherDay : new DateTime(otherDay);
        if (escapeYear) {
            return this.getMonth() == other.getMonth() && this.getDate() == other.getDate();
        }
        return this.getAllDaysCount() == other.getAllDaysCount();
    }

    public boolean isTheSameDayWith(Date otherDay) {
        return this.isTheSameDayWith(otherDay, false);
    }

    private void reset() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        this.myYear = calendar.get(1);
        this.myMonth = calendar.get(2) + 1;
        this.myDate = calendar.get(5);
        this.myDay = calendar.get(7) + 1;
    }

    @Override
    public int getYear() {
        if (this.myYear == null) {
            this.reset();
        }
        return this.myYear;
    }

    @Override
    public void setYear(int _year) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMonth() {
        if (this.myMonth == null) {
            this.reset();
        }
        return this.myMonth;
    }

    @Override
    public void setMonth(int _month) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDate() {
        if (this.myDate == null) {
            this.reset();
        }
        return this.myDate;
    }

    @Override
    public void setDate(int _date) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDay() {
        if (this.myDay == null) {
            this.reset();
        }
        return this.myDay;
    }

    @Override
    public String toString() {
        if (this.stringValue == null) {
            this.stringValue = this.getYear() + "-" + this.getMonth() + "-" + this.getDate() + " " + this.getHours() + ":" + this.getMinutes() + ":" + this.getSeconds() + "." + this.getMilliseconds();
        }
        return this.stringValue;
    }

    @Override
    public Object clone() {
        return new DateTime(this.getTime());
    }

    public long getAllDaysCount() {
        return TimeUnit.MILLISECONDS.toDays(this.getTime());
    }

    public long getAllHoursCount() {
        return TimeUnit.MILLISECONDS.toHours(this.getTime());
    }

    public long getAllMillisecondsCount() {
        return this.getTime();
    }

    public long getAllMinutesCount() {
        return TimeUnit.MILLISECONDS.toMinutes(this.getTime());
    }

    public long getAllSecondsCount() {
        return TimeUnit.MILLISECONDS.toSeconds(this.getTime());
    }

    @Override
    public int getHours() {
        return TimeKit.getHours(this.getTime());
    }

    @Override
    public void setHours(int _hours) {
        throw new UnsupportedOperationException();
    }

    public int getMilliseconds() {
        return TimeKit.getMilliseconds(this.getTime());
    }

    @Override
    public int getMinutes() {
        return TimeKit.getMinutes(this.getTime());
    }

    @Override
    public void setMinutes(int _minutes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSeconds() {
        return TimeKit.getSeconds(this.getTime());
    }

    @Override
    public void setSeconds(int _seconds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getTime() {
        return super.getTime();
    }

    @Override
    public void setTime(long _time) {
        throw new UnsupportedOperationException();
    }

    public Date toDate() {
        return new Date(super.getTime());
    }

    public DateTime ceilDate() {
        return new DateTime((this.getAllDaysCount() + 1L) * TimeSpan.DATE.getTime());
    }

    public DateTime ceilHour() {
        return new DateTime((this.getAllHoursCount() + 1L) * TimeSpan.HOUR.getTime());
    }

    public DateTime ceilMinute() {
        return new DateTime((this.getAllMinutesCount() + 1L) * TimeSpan.MINUTE.getTime());
    }

    public DateTime ceilSecond() {
        return new DateTime((this.getAllSecondsCount() + 1L) * TimeSpan.SECOND.getTime());
    }

    public DateTime floorDate() {
        return new DateTime(this.getAllDaysCount() * TimeSpan.DATE.getTime());
    }

    public DateTime floorHour() {
        return new DateTime(this.getAllHoursCount() * TimeSpan.HOUR.getTime());
    }

    public DateTime floorMinute() {
        return new DateTime(this.getAllMinutesCount() * TimeSpan.MINUTE.getTime());
    }

    public DateTime floorSecond() {
        return new DateTime(this.getAllSecondsCount() * TimeSpan.SECOND.getTime());
    }
}

