/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.time;

import java.time.Instant;
import java.util.Comparator;
import me.magicall.support.coll.CompareKit;

@FunctionalInterface
public interface HasEndTime {
    public static final boolean DEFAULT_INCLUDING_END_TIME = false;

    public Instant endTime();

    default public boolean includeEndingTime() {
        return false;
    }

    default public boolean isEnded() {
        return this.isEndedWhen(System.currentTimeMillis());
    }

    default public boolean isEndedWhen(long when) {
        Instant endTime = this.endTime();
        if (endTime == null) {
            return false;
        }
        return HasEndTime.isEndedWhen(endTime.toEpochMilli(), when, this.includeEndingTime());
    }

    public static boolean isEndedWhen(long endTime, long when, boolean includeEndingTime) {
        long timeOffset = when - endTime;
        return includeEndingTime ? timeOffset >= 0L : timeOffset > 0L;
    }

    public static Comparator<HasEndTime> endTimeAscNullLast() {
        return CompareKit.keyAscNullLast(HasEndTime::endTime);
    }
}

