/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.time;

import java.time.Instant;
import java.util.Comparator;
import me.magicall.support.coll.CompareKit;

@FunctionalInterface
public interface HasStartTime {
    public static final boolean DEFAULT_INCLUDING_START_TIME = true;

    public Instant startTime();

    default public boolean includeStartingTime() {
        return true;
    }

    default public boolean isStarted() {
        return this.isStartedWhen(System.currentTimeMillis());
    }

    default public boolean isStartedWhen(long when) {
        Instant startTime = this.startTime();
        if (startTime == null) {
            return false;
        }
        return HasStartTime.isStartedWhen(startTime.toEpochMilli(), when, this.includeStartingTime());
    }

    public static boolean isStartedWhen(long startTime, long when, boolean includeStartingTime) {
        long timeOffset = when - startTime;
        return includeStartingTime ? timeOffset >= 0L : timeOffset > 0L;
    }

    public static Comparator<HasStartTime> startTimeAscNullLast() {
        return CompareKit.keyAscNullLast(HasStartTime::startTime);
    }
}

