/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.time;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;

@Deprecated
public enum TimeFormatter {
    Y4_M2_D2_H2_MIN2_S2_MS3("yyyy-MM-dd HH:mm:ss.SSS"),
    Y4_M2_D2_H2_MIN2_S2_URL("yyyy-MM-dd+HH:mm:ss"),
    Y4_M2_D2_H2_MIN2_S2("yyyy-MM-dd HH:mm:ss"),
    Y2_M2_D2_H2_MIN2_S2("yy-MM-dd HH:mm:ss"),
    Y4_M2_D2_H2_M2("yyyy-MM-dd HH:mm"),
    Y2_M2_D2_H2_MIN2("yy-MM-dd HH:mm"),
    Y4_M2_D2("yyyy-MM-dd"),
    Y4M2D2H2MIN2S2MS3("yyyyMMddHHmmssSSS"),
    Y4M2D2("yyyyMMdd"),
    Y4\u5e74M2\u6708D2\u65e5("yyyy\u5e74MM\u6708dd\u65e5"),
    Y4\u5e74M2\u6708D2\u65e5H2\u65f6M2\u5206S2\u79d2("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2"),
    M2_D2("MM-dd"),
    Y4_M2("yyyy-MM"),
    H2_MIN2("HH:mm"),
    M_D("M.d"),
    H2MIN2("HHmm"),
    Y4_M2_D2_H2_m2_s2("yyyy-MM-dd-HH-mm-ss"),
    M("M");

    public final String pattern;

    private TimeFormatter(String pattern) {
        this.pattern = pattern;
    }

    public static String tryToFormat(Date date) {
        TimeFormatter[] formatters;
        for (TimeFormatter f : formatters = TimeFormatter.values()) {
            try {
                return f.format(date);
            }
            catch (Exception exception) {
            }
        }
        return date.toString();
    }

    public static Date tryToParse(String s, ParsePosition pos) {
        TimeFormatter[] formatters;
        int index = pos.getIndex();
        for (TimeFormatter f : formatters = TimeFormatter.values()) {
            Date date = f.parse(s, pos);
            if (date != null) {
                return date;
            }
            pos.setIndex(index);
        }
        return null;
    }

    public static Date tryToParse(String s) {
        TimeFormatter[] formatters = TimeFormatter.values();
        return Arrays.stream(formatters).map(f -> f.parse(s, new ParsePosition(0))).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public String format(Date date) {
        return new SimpleDateFormat(this.pattern).format(date);
    }

    public Date parse(String s) {
        try {
            return new SimpleDateFormat(this.pattern).parse(s);
        }
        catch (ParseException ignored) {
            return null;
        }
    }

    public Date parse(String s, ParsePosition pos) {
        return new SimpleDateFormat(this.pattern).parse(s, pos);
    }

    public String toString() {
        return this.pattern;
    }
}

