/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.time;

import com.google.common.collect.Range;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.Year;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import me.magicall.support.lang.java.Kits;
import me.magicall.support.time.TimeConst;
import me.magicall.support.time.TimeFormatter;
import me.magicall.support.time.TimeSpan;

public interface TimeKit {
    public static final String YYYY_MM = "yyyy-MM";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final Pattern YYYY_MM_PATTERN = Pattern.compile("\\d{4}-\\d{2}");
    public static final Pattern YYYY_MM_DD_PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
    public static final Pattern YYYY_PATTERN = Pattern.compile("\\d{4}");
    public static final MonthDay LEAP_DAY = MonthDay.of(Month.FEBRUARY, 29);

    public static Date dateBefore(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static Date dateAfter(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    public static boolean isYear(String s) {
        return YYYY_PATTERN.matcher(s).matches();
    }

    public static boolean isYearMonth(String s) {
        return YYYY_MM_PATTERN.matcher(s).matches();
    }

    public static boolean isYearMonthDate(String s) {
        return YYYY_MM_DD_PATTERN.matcher(s).matches();
    }

    public static Date notLaterThanToday(Date date) {
        return TimeKit.min(date, new Date());
    }

    public static Date min(Date d1, Date d2) {
        return d1.after(d2) ? d2 : d1;
    }

    public static boolean isSameYear(Date d1, Date d2) {
        return TimeKit.yearNumOf(d1) == TimeKit.yearNumOf(d2);
    }

    public static Date lastYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, -1);
        return c.getTime();
    }

    public static boolean includingLeapDay(Range<Date> timeRange) {
        return TimeKit.countLeapDays(timeRange) == 0;
    }

    public static int countLeapDays(Range<Date> timeRange) {
        Range<Date> closed = TimeKit.toCloseDateRange(timeRange);
        LocalDate localDate1 = LocalDate.from(((Date)closed.lowerEndpoint()).toInstant());
        LocalDate localDate2 = LocalDate.from(((Date)closed.upperEndpoint()).toInstant());
        int year1 = localDate1.getYear();
        int year2 = localDate2.getYear();
        return (int)IntStream.range(localDate1.isLeapYear() ? year1 : year1 + 1, localDate2.isLeapYear() ? year2 : year2 - 1).mapToObj(Year::of).filter(Year::isLeap).map(year -> year.atMonthDay(LEAP_DAY)).filter(leapDate -> leapDate.equals(localDate1) || leapDate.equals(localDate2) || leapDate.isAfter(localDate1) && leapDate.isBefore(localDate2)).count();
    }

    public static boolean isLeapDay(LocalDate date) {
        return MonthDay.from(date).equals(LEAP_DAY);
    }

    public static boolean isLeapDay(Date date) {
        return TimeKit.isLeapDay(LocalDate.from(date.toInstant()));
    }

    public static int yearNumOf(Date date) {
        return date.toInstant().get(ChronoField.YEAR);
    }

    public static Range<Date> toOpenDateRange(Range<Date> dateRange) {
        Date d1 = (Date)dateRange.lowerEndpoint();
        Date d2 = (Date)dateRange.upperEndpoint();
        return Range.open((Comparable)(dateRange.contains((Comparable)d1) ? TimeKit.dateBefore(d1) : d1), (Comparable)(dateRange.contains((Comparable)d2) ? TimeKit.dateAfter(d2) : d2));
    }

    public static Range<Date> toCloseDateRange(Range<Date> dateRange) {
        Date d1 = (Date)dateRange.lowerEndpoint();
        Date d2 = (Date)dateRange.upperEndpoint();
        return Range.closed((Comparable)(dateRange.contains((Comparable)d1) ? d1 : TimeKit.dateAfter(d1)), (Comparable)(dateRange.contains((Comparable)d2) ? d2 : TimeKit.dateBefore(d2)));
    }

    public static boolean isDatesCrossingYear(Range<Date> timeRange) {
        Date d1 = (Date)timeRange.lowerEndpoint();
        Date d2 = (Date)timeRange.upperEndpoint();
        return !TimeKit.isSameYear(timeRange.contains((Comparable)d1) ? d1 : TimeKit.dateAfter(d1), timeRange.contains((Comparable)d2) ? d2 : TimeKit.dateBefore(d2));
    }

    public static Date parse(String s) {
        if (Kits.STR.isEmpty(s)) {
            return null;
        }
        String trimed = s.trim();
        SimpleDateFormat format = new SimpleDateFormat();
        for (TimeFormatter f : TimeFormatter.values()) {
            format.applyPattern(f.pattern);
            Date d = format.parse(trimed, new ParsePosition(0));
            if (d == null) continue;
            return d;
        }
        return null;
    }

    public static boolean isTheSameDay(Date day1, Date day2, boolean escapeYear) {
        return TimeKit.isTheSameDay(day1, day2, escapeYear, true);
    }

    public static boolean isTheSameDay(Date day1, Date day2, boolean escapeYear, boolean checkSummerTime) {
        return checkSummerTime ? TimeKit.isTheSameDayCheckSummerTime(day1, day2, escapeYear) : TimeKit.isTheSameDayNoSummerTimeCheck(day1, day2, escapeYear);
    }

    private static boolean isTheSameDayCheckSummerTime(Date day1, Date day2, boolean escapeYear) {
        Calendar c = Calendar.getInstance();
        c.setTime(day1);
        int y = c.get(1);
        int m = c.get(2);
        int d = c.get(5);
        c.setTime(day2);
        return (escapeYear || y == c.get(1)) && m == c.get(2) && d == c.get(5);
    }

    private static boolean isTheSameDayNoSummerTimeCheck(Date day1, Date day2, boolean escapeYear) {
        long t1 = day1.getTime();
        long t2 = day2.getTime();
        if (escapeYear) {
            long offset4Y1 = (t1 + TimeConst.HOUR8) % TimeConst.YEAR4;
            long offset4Y2 = (t2 + TimeConst.HOUR8) % TimeConst.YEAR4;
            if (offset4Y1 < TimeConst.LEAP_DAY_START_IN_4Y) {
                if (offset4Y2 < TimeConst.LEAP_DAY_START_IN_4Y) {
                    return offset4Y1 % TimeConst.YEAR_COMMON / TimeUnit.DAYS.toMillis(1L) == offset4Y2 % TimeConst.YEAR_COMMON / TimeUnit.DAYS.toMillis(1L);
                }
                if (offset4Y2 >= TimeConst.LEAP_DAY_END_IN_4Y) {
                    return offset4Y1 % TimeConst.YEAR_COMMON / TimeUnit.DAYS.toMillis(1L) == (offset4Y2 - TimeUnit.DAYS.toMillis(1L)) % TimeConst.YEAR_COMMON / TimeUnit.DAYS.toMillis(1L);
                }
                return false;
            }
            if (offset4Y1 >= TimeConst.LEAP_DAY_END_IN_4Y) {
                if (offset4Y2 < TimeConst.LEAP_DAY_START_IN_4Y) {
                    return (offset4Y1 - TimeUnit.DAYS.toMillis(1L)) % TimeConst.YEAR_COMMON / TimeUnit.DAYS.toMillis(1L) == offset4Y2 % TimeConst.YEAR_COMMON / TimeUnit.DAYS.toMillis(1L);
                }
                if (offset4Y2 >= TimeConst.LEAP_DAY_END_IN_4Y) {
                    return offset4Y1 % TimeConst.YEAR_COMMON / TimeUnit.DAYS.toMillis(1L) == offset4Y2 % TimeConst.YEAR_COMMON / TimeUnit.DAYS.toMillis(1L);
                }
                return false;
            }
            return offset4Y2 >= TimeConst.LEAP_DAY_START_IN_4Y && offset4Y2 < TimeConst.LEAP_DAY_END_IN_4Y;
        }
        long t81 = t1 / TimeConst.HOUR8;
        long t82 = t2 / TimeConst.HOUR8;
        if (t81 == t82) {
            return true;
        }
        return (t81 + 1L) / 3L == (t82 + 1L) / 3L;
    }

    public static long toMillisecond(int year, int month, int date, int hour, int minute, int second, int millisecond) {
        long y;
        if (year > 1972) {
            int lyCount = TimeKit.leapYearCount(year);
            y = (long)(year - 1970) * TimeSpan.YEAR.getTime() + (long)lyCount * TimeSpan.DATE.getTime();
        } else {
            y = (long)(year - 1970) * TimeSpan.YEAR.getTime();
        }
        List<TimeSpan> ms = month > 2 && Year.isLeap(year) ? TimeSpan.msOfLeapYearMonths() : TimeSpan.msOfCommonYearMonths();
        long m = IntStream.range(0, month - 1).mapToLong(i -> ((TimeSpan)ms.get(i)).getTime()).sum();
        return y + m + (long)(date - 1) * TimeSpan.DATE.getTime() + (long)hour * TimeSpan.HOUR.getTime() + (long)minute * TimeSpan.MINUTE.getTime() + (long)second * TimeSpan.SECOND.getTime() + (long)millisecond;
    }

    public static int leapYearCount(int year) {
        if (year < 1970) {
            throw new IllegalArgumentException("year < 1970:" + year);
        }
        if (year < 1972) {
            return 0;
        }
        return (year - 1972) / 4 + 1;
    }

    public static int getHours(long milliseconds) {
        return (int)(milliseconds % TimeUnit.DAYS.toMillis(1L) / TimeConst.HOUR);
    }

    public static int getMinutes(long milliseconds) {
        return (int)(milliseconds % TimeConst.HOUR / TimeConst.MINUTE);
    }

    public static int getSeconds(long milliseconds) {
        return (int)(milliseconds % TimeConst.MINUTE / TimeConst.SECOND);
    }

    public static int getMilliseconds(long milliseconds) {
        return (int)(milliseconds % TimeConst.SECOND);
    }

    public static List<Date> thisWeek() {
        Calendar c = Calendar.getInstance();
        c.set(7, 1);
        int size = 7;
        ArrayList<Date> list = new ArrayList<Date>(size);
        while (true) {
            list.add(c.getTime());
            if (--size == 0) break;
            c.add(5, 1);
        }
        return list;
    }

    public static int[] daysOfCommonYearMonth() {
        return Arrays.stream(Month.values()).mapToInt(e -> e.length(false)).toArray();
    }

    public static int[] daysOfLeapYearMonth() {
        return Arrays.stream(Month.values()).mapToInt(e -> e.length(true)).toArray();
    }

    public static LocalDateTime now() {
        return LocalDateTime.now(ZoneId.systemDefault());
    }
}

