/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.time;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.magicall.support.time.DateTime;
import me.magicall.support.time.TimeKit;

@Deprecated
public final class TimeSpan
implements Serializable,
Comparable<TimeSpan> {
    public static final TimeSpan MILLESECOND = new TimeSpan(TimeUnit.MILLISECONDS.toMillis(1L));
    public static final TimeSpan SECOND = new TimeSpan(TimeUnit.SECONDS.toMillis(1L));
    public static final TimeSpan MINUTE = new TimeSpan(TimeUnit.MINUTES.toMillis(1L));
    public static final TimeSpan HOUR = new TimeSpan(TimeUnit.HOURS.toMillis(1L));
    public static final TimeSpan HOUR8 = new TimeSpan(TimeUnit.HOURS.toMillis(8L));
    public static final TimeSpan HOUR16 = new TimeSpan(TimeUnit.HOURS.toMillis(16L));
    public static final TimeSpan DATE = new TimeSpan(TimeUnit.DAYS.toMillis(1L));
    public static final TimeSpan WEEK = new TimeSpan(TimeUnit.DAYS.toMillis(7L));
    public static final TimeSpan DATE28 = new TimeSpan(TimeUnit.DAYS.toMillis(28L));
    public static final TimeSpan DATE29 = new TimeSpan(TimeUnit.DAYS.toMillis(29L));
    public static final TimeSpan DATE30 = new TimeSpan(TimeUnit.DAYS.toMillis(30L));
    public static final TimeSpan DATE31 = new TimeSpan(TimeUnit.DAYS.toMillis(31L));
    public static final TimeSpan DATE90 = new TimeSpan(TimeUnit.DAYS.toMillis(90L));
    public static final TimeSpan DATE180 = new TimeSpan(TimeUnit.DAYS.toMillis(180L));
    public static final TimeSpan DATE365 = new TimeSpan(TimeUnit.DAYS.toMillis(365L));
    public static final TimeSpan DATE366 = new TimeSpan(TimeUnit.DAYS.toMillis(366L));
    public static final TimeSpan YEAR = DATE365;
    public static final TimeSpan YEAR2 = new TimeSpan(TimeSpan.YEAR.time * 2L);
    public static final TimeSpan YEAR_LEAP = DATE366;
    public static final TimeSpan YEAR4 = new TimeSpan(TimeSpan.YEAR.time * 3L + TimeSpan.YEAR_LEAP.time);
    private static final TimeSpan[] MONTHS_COMMON = new TimeSpan[]{DATE31, DATE28, DATE31, DATE30, DATE31, DATE30, DATE31, DATE31, DATE30, DATE31, DATE30, DATE31};
    private static final List<TimeSpan> MONTHS_COMMON_COLLECTION = List.of(MONTHS_COMMON);
    private static final TimeSpan[] MONTHS_LEAP = new TimeSpan[]{DATE31, DATE29, DATE31, DATE30, DATE31, DATE30, DATE31, DATE31, DATE30, DATE31, DATE30, DATE31};
    private static final List<TimeSpan> MONTHS_LEAP_COLLECTION = List.of(MONTHS_LEAP);
    private static final long serialVersionUID = 5777743030392159993L;
    private final long time;
    private volatile transient String stringValue;

    public TimeSpan(long time) {
        this.time = time;
    }

    public static List<TimeSpan> msOfCommonYearMonths() {
        return MONTHS_COMMON_COLLECTION;
    }

    public static List<TimeSpan> msOfLeapYearMonths() {
        return MONTHS_LEAP_COLLECTION;
    }

    static long add(long t, TimeSpan ... others) {
        return t += Arrays.stream(others).mapToLong(s -> s.time).sum();
    }

    static long sub(long t, TimeSpan ... others) {
        for (TimeSpan s : others) {
            t -= s.time;
        }
        return t;
    }

    public static void main(String ... args) {
        TimeSpan span = new TimeSpan(1L);
        System.out.println("@@@@@@" + span.add((TimeSpan)new TimeSpan((long)2L), (TimeSpan)new TimeSpan((long)3L)).time);
    }

    public long getAllDaysCount() {
        return TimeUnit.MILLISECONDS.toDays(this.time);
    }

    public long getAllHoursCount() {
        return TimeUnit.MILLISECONDS.toHours(this.time);
    }

    public long getAllMinutesCount() {
        return TimeUnit.MILLISECONDS.toMinutes(this.time);
    }

    public long getAllSecondsCount() {
        return TimeUnit.MILLISECONDS.toSeconds(this.time);
    }

    public long getAllMillisecondsCount() {
        return this.time;
    }

    public int getHours() {
        return TimeKit.getHours(this.time);
    }

    public int getMinutes() {
        return TimeKit.getMinutes(this.time);
    }

    public int getSeconds() {
        return TimeKit.getSeconds(this.time);
    }

    public int getMilliseconds() {
        return TimeKit.getMilliseconds(this.time);
    }

    public long getTime() {
        return this.time;
    }

    public TimeSpan add(TimeSpan other) {
        return new TimeSpan(this.time + other.time);
    }

    public TimeSpan add(TimeSpan o1, TimeSpan o2) {
        return new TimeSpan(this.time + o1.time + o2.time);
    }

    public TimeSpan add(TimeSpan o1, TimeSpan o2, TimeSpan o3) {
        return new TimeSpan(this.time + o1.time + o2.time + o3.time);
    }

    public TimeSpan add(TimeSpan other, TimeSpan ... others) {
        return new TimeSpan(TimeSpan.add(this.time + other.time, others));
    }

    public DateTime add(DateTime timePoint) {
        return new DateTime(this.time + timePoint.getTime());
    }

    public TimeSpan sub(TimeSpan other) {
        return new TimeSpan(this.time - other.time);
    }

    public TimeSpan sub(TimeSpan o1, TimeSpan o2) {
        return new TimeSpan(this.time - o1.time - o2.time);
    }

    public TimeSpan sub(TimeSpan o1, TimeSpan o2, TimeSpan o3) {
        return new TimeSpan(this.time - o1.time - o2.time - o3.time);
    }

    public TimeSpan sub(TimeSpan ... others) {
        return new TimeSpan(TimeSpan.sub(this.time, others));
    }

    public double div(TimeSpan other) {
        return this.time / other.time;
    }

    public TimeSpan multi(int times) {
        return new TimeSpan(this.time * (long)times);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeSpan other = (TimeSpan)obj;
        return this.time == other.time;
    }

    public Date toDate() {
        return new DateTime(this.time);
    }

    public String format(DateFormat dateFormat) {
        return dateFormat.format(this.toDate());
    }

    public String format(String pattern) {
        return this.format(new SimpleDateFormat(pattern));
    }

    public String toString() {
        if (this.stringValue == null) {
            this.stringValue = this.getAllDaysCount() + " days " + this.getHours() + " hours " + this.getMinutes() + " minutes " + this.getSeconds() + " seconds " + this.getMilliseconds() + " ms ";
        }
        return this.stringValue;
    }

    @Override
    public int compareTo(TimeSpan o) {
        if (this.time > o.time) {
            return 1;
        }
        if (this.time < o.time) {
            return -1;
        }
        return 0;
    }
}

