/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfgui.gui;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.mattstudios.mfgui.gui.GuiItem;
import me.mattstudios.mfgui.gui.GuiListener;
import me.mattstudios.mfgui.gui.components.GuiAction;
import me.mattstudios.mfgui.gui.components.GuiException;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public final class GUI
implements InventoryHolder {
    private Inventory inventory;
    private String title;
    private int rows;
    private final Map<Integer, GuiItem> guiItems;
    private final Map<Integer, GuiAction<InventoryClickEvent>> slotActions;
    private GuiAction<InventoryClickEvent> defaultClickAction;
    private GuiAction<InventoryCloseEvent> closeGuiAction;
    private GuiAction<InventoryOpenEvent> openGuiAction;
    private static boolean registeredListener;
    private boolean updating;

    public GUI(Plugin plugin, int rows, String title) {
        int finalRows = rows;
        if (rows < 1 || rows > 6) {
            finalRows = 1;
        }
        this.rows = finalRows;
        this.title = title;
        this.guiItems = new HashMap<Integer, GuiItem>();
        this.slotActions = new HashMap<Integer, GuiAction<InventoryClickEvent>>();
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(rows * 9), (String)title);
        if (!registeredListener) {
            Bukkit.getPluginManager().registerEvents((Listener)new GuiListener(), plugin);
            registeredListener = true;
        }
    }

    public GUI(Plugin plugin, String title) {
        this(plugin, 1, title);
    }

    public GUI setRows(int rows) {
        int finalRows = rows;
        if (rows < 1 || rows > 6) {
            finalRows = 1;
        }
        this.rows = finalRows;
        return this;
    }

    public GUI setItem(int slot, GuiItem guiItem) {
        if (!this.isValidSlot(slot)) {
            throw new GuiException("Invalid item slot!");
        }
        this.guiItems.put(slot, guiItem);
        return this;
    }

    public GUI setItem(int row, int col, GuiItem guiItem) {
        return this.setItem(this.getSlotFromRowCol(row, col), guiItem);
    }

    public GUI setFillItem(GuiItem guiItem) {
        for (int i = 0; i < this.rows * 9; ++i) {
            if (this.guiItems.containsKey(i)) continue;
            this.guiItems.put(i, guiItem);
        }
        return this;
    }

    public GUI setDefaultClickAction(GuiAction<InventoryClickEvent> defaultClickAction) {
        this.defaultClickAction = defaultClickAction;
        return this;
    }

    public GUI setCloseGuiAction(GuiAction<InventoryCloseEvent> closeGuiAction) {
        this.closeGuiAction = closeGuiAction;
        return this;
    }

    public GUI setOpenGuiAction(GuiAction<InventoryOpenEvent> openGuiAction) {
        this.openGuiAction = openGuiAction;
        return this;
    }

    public GUI addSlotAction(int slot, GuiAction<InventoryClickEvent> slotAction) {
        if (!this.isValidSlot(slot)) {
            return this;
        }
        this.slotActions.put(slot, slotAction);
        return this;
    }

    public GUI addSlotAction(int row, int col, GuiAction<InventoryClickEvent> slotAction) {
        return this.addSlotAction(this.getSlotFromRowCol(row, col), slotAction);
    }

    public GuiItem getGuiItem(int slot) {
        return this.isValidSlot(slot) ? this.guiItems.get(slot) : null;
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public void open(HumanEntity player) {
        this.inventory.clear();
        for (int slot : this.guiItems.keySet()) {
            this.inventory.setItem(slot, this.guiItems.get(slot).getItemStack());
        }
        player.openInventory(this.inventory);
    }

    public void update() {
        this.updating = true;
        for (HumanEntity player : this.inventory.getViewers()) {
            this.open(player);
        }
        this.updating = false;
    }

    public void updateItem(int slot, ItemStack itemStack) {
        if (!this.guiItems.containsKey(slot)) {
            return;
        }
        this.guiItems.get(slot).setItemStack(itemStack);
        this.inventory.setItem(slot, this.guiItems.get(slot).getItemStack());
    }

    public void updateItem(int row, int col, ItemStack itemStack) {
        this.updateItem(this.getSlotFromRowCol(row, col), itemStack);
    }

    @Beta
    public void updateTitle(String title) {
        this.title = title;
        this.updating = true;
        ArrayList viewers = new ArrayList(this.inventory.getViewers());
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.inventory.getSize(), (String)this.title);
        for (HumanEntity player : viewers) {
            this.open(player);
        }
        this.updating = false;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    GuiAction<InventoryClickEvent> getDefaultClickAction() {
        return this.defaultClickAction;
    }

    GuiAction<InventoryCloseEvent> getCloseGuiAction() {
        return this.closeGuiAction;
    }

    GuiAction<InventoryOpenEvent> getOpenGuiAction() {
        return this.openGuiAction;
    }

    GuiAction<InventoryClickEvent> getSlotAction(int slot) {
        return this.isValidSlot(slot) ? this.slotActions.get(slot) : null;
    }

    private boolean isValidSlot(int slot) {
        return slot >= 0 && slot < this.rows * 9;
    }

    private int getSlotFromRowCol(int row, int col) {
        return col + (row - 1) * 9 - 1;
    }
}

