/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfgui.gui.components;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;

public final class ItemNBT {
    public static ItemStack setNBTTag(ItemStack itemStack, String key, String value) {
        Object nmsItemStack = ItemNBT.asNMSCopy(itemStack);
        Object itemCompound = ItemNBT.hasTag(nmsItemStack) ? ItemNBT.getTag(nmsItemStack) : ItemNBT.newNBTTagCompound();
        ItemNBT.setString(itemCompound, key, value);
        ItemNBT.setTag(nmsItemStack, itemCompound);
        return ItemNBT.asBukkitCopy(nmsItemStack);
    }

    public static String getNBTTag(ItemStack itemStack, String key) {
        Object nmsItemStack = ItemNBT.asNMSCopy(itemStack);
        Object itemCompound = ItemNBT.hasTag(nmsItemStack) ? ItemNBT.getTag(nmsItemStack) : ItemNBT.newNBTTagCompound();
        return ItemNBT.getString(itemCompound, key);
    }

    private static void setString(Object itemCompound, String key, String value) {
        try {
            Objects.requireNonNull(ItemNBT.getNMSClass("NBTTagCompound")).getMethod("setString", String.class, String.class).invoke(itemCompound, key, value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static String getString(Object itemCompound, String key) {
        try {
            return (String)Objects.requireNonNull(ItemNBT.getNMSClass("NBTTagCompound")).getMethod("getString", String.class).invoke(itemCompound, key);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    private static boolean hasTag(Object nmsItemStack) {
        try {
            return (Boolean)Objects.requireNonNull(ItemNBT.getNMSClass("ItemStack")).getMethod("hasTag", new Class[0]).invoke(nmsItemStack, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    private static Object getTag(Object nmsItemStack) {
        try {
            return Objects.requireNonNull(ItemNBT.getNMSClass("ItemStack")).getMethod("getTag", new Class[0]).invoke(nmsItemStack, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    private static void setTag(Object nmsItemStack, Object itemCompound) {
        try {
            Objects.requireNonNull(ItemNBT.getNMSClass("ItemStack")).getMethod("setTag", ItemNBT.getNMSClass("NBTTagCompound")).invoke(nmsItemStack, itemCompound);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static Object newNBTTagCompound() {
        try {
            return Objects.requireNonNull(ItemNBT.getNMSClass("NBTTagCompound")).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    private static Object asNMSCopy(ItemStack itemStack) {
        try {
            return Objects.requireNonNull(ItemNBT.getCraftItemStackClass()).getMethod("asNMSCopy", ItemStack.class).invoke(null, itemStack);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    private static ItemStack asBukkitCopy(Object nmsItemStack) {
        try {
            return (ItemStack)Objects.requireNonNull(ItemNBT.getCraftItemStackClass()).getMethod("asBukkitCopy", ItemNBT.getNMSClass("ItemStack")).invoke(null, nmsItemStack);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    private static String getServerVersion() {
        return Bukkit.getServer().getClass().getPackage().getName().substring(Bukkit.getServer().getClass().getPackage().getName().lastIndexOf(46) + 1);
    }

    private static Class<?> getNMSClass(String className) {
        try {
            return Class.forName("net.minecraft.server." + ItemNBT.getServerVersion() + "." + className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class<?> getCraftItemStackClass() {
        try {
            return Class.forName("org.bukkit.craftbukkit." + ItemNBT.getServerVersion() + ".inventory.CraftItemStack");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

