/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfgui.gui.guis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.mattstudios.mfgui.gui.guis.BaseGui;
import me.mattstudios.mfgui.gui.guis.GuiItem;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class PaginatedGui
extends BaseGui {
    private final List<GuiItem> pageItems = new ArrayList<GuiItem>();
    private final Map<Integer, GuiItem> currentPage = new HashMap<Integer, GuiItem>();
    private final Map<Integer, Integer> twe = new HashMap<Integer, Integer>();
    private int pageSize;
    private int page = 1;

    public PaginatedGui(@NotNull Plugin plugin, int rows, int pageSize, @NotNull String title) {
        super(plugin, rows, title);
        this.pageSize = pageSize;
        if (rows < 2) {
            this.setRows(2);
        }
    }

    public PaginatedGui(@NotNull Plugin plugin, int rows, @NotNull String title) {
        this(plugin, rows, 0, title);
    }

    public PaginatedGui(@NotNull Plugin plugin, @NotNull String title) {
        this(plugin, 2, title);
    }

    public BaseGui setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public BaseGui addItem(@NotNull GuiItem item) {
        this.pageItems.add(item);
        return this;
    }

    @Override
    public BaseGui addItem(GuiItem ... items) {
        this.pageItems.addAll(Arrays.asList(items));
        return this;
    }

    @Override
    public void update() {
        this.setUpdating(true);
        for (HumanEntity player : this.getInventory().getViewers()) {
            this.open(player, this.page);
        }
        this.setUpdating(false);
    }

    public void updatePageItem(int slot, @NotNull ItemStack itemStack) {
        if (!this.currentPage.containsKey(slot)) {
            return;
        }
        GuiItem guiItem = this.currentPage.get(slot);
        guiItem.setItemStack(itemStack);
        this.getInventory().setItem(slot, guiItem.getItemStack());
    }

    public void updatePageItem(int row, int col, @NotNull ItemStack itemStack) {
        this.updateItem(this.getSlotFromRowCol(row, col), itemStack);
    }

    public void updatePageItem(int slot, @NotNull GuiItem item) {
        if (!this.currentPage.containsKey(slot)) {
            return;
        }
        this.currentPage.put(slot, item);
        this.getInventory().setItem(slot, item.getItemStack());
    }

    public void updatePageItem(int row, int col, @NotNull GuiItem item) {
        this.updateItem(this.getSlotFromRowCol(row, col), item);
    }

    @Override
    public void open(@NotNull HumanEntity player) {
        this.open(player, 1);
    }

    public void open(@NotNull HumanEntity player, int openPage) {
        if (openPage <= this.getPagesNum() || openPage > 0) {
            this.page = openPage;
        }
        this.getInventory().clear();
        this.currentPage.clear();
        this.populateGui();
        if (this.pageSize == 0) {
            this.pageSize = this.calculatePageSize();
        }
        this.populatePage();
        player.openInventory(this.getInventory());
    }

    public Map<Integer, GuiItem> getCurrentPageItems() {
        return this.currentPage;
    }

    public List<GuiItem> getPageItems() {
        return this.pageItems;
    }

    public int getCurrentPageNum() {
        return this.page;
    }

    public int getNextPageNum() {
        if (this.page + 1 > this.getPagesNum()) {
            return this.page;
        }
        return this.page + 1;
    }

    public int getPrevPageNum() {
        if (this.page - 1 == 0) {
            return this.page;
        }
        return this.page - 1;
    }

    public boolean nextPage() {
        if (this.page + 1 > this.getPagesNum()) {
            return false;
        }
        ++this.page;
        this.updatePage();
        return true;
    }

    public boolean prevPage() {
        if (this.page - 1 == 0) {
            return false;
        }
        --this.page;
        this.updatePage();
        return true;
    }

    GuiItem getPageItem(int slot) {
        return this.currentPage.get(slot);
    }

    private List<GuiItem> getPage(int givenPage) {
        int page = givenPage - 1;
        ArrayList<GuiItem> guiPage = new ArrayList<GuiItem>();
        int max = page * this.pageSize + this.pageSize;
        if (max > this.pageItems.size()) {
            max = this.pageItems.size();
        }
        for (int i = page * this.pageSize; max > i; ++i) {
            guiPage.add(this.pageItems.get(i));
        }
        return guiPage;
    }

    private int getPagesNum() {
        return (int)Math.ceil((double)this.pageItems.size() / (double)this.pageSize);
    }

    private void populatePage() {
        block0: for (GuiItem guiItem : this.getPage(this.page)) {
            for (int slot = 0; slot < this.getRows() * 9; ++slot) {
                if (this.getInventory().getItem(slot) != null) continue;
                this.currentPage.put(slot, guiItem);
                this.getInventory().setItem(slot, guiItem.getItemStack());
                continue block0;
            }
        }
    }

    private void clearPage() {
        for (Map.Entry<Integer, GuiItem> entry : this.currentPage.entrySet()) {
            this.getInventory().setItem(entry.getKey().intValue(), null);
        }
    }

    private void updatePage() {
        this.clearPage();
        this.populatePage();
    }

    private int calculatePageSize() {
        int counter = 0;
        for (int slot = 0; slot < this.getRows() * 9; ++slot) {
            if (this.getInventory().getItem(slot) != null) continue;
            ++counter;
        }
        return counter;
    }
}

