/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfgui.gui.guis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.mattstudios.mfgui.gui.components.GuiAction;
import me.mattstudios.mfgui.gui.components.GuiException;
import me.mattstudios.mfgui.gui.components.GuiFiller;
import me.mattstudios.mfgui.gui.components.GuiType;
import me.mattstudios.mfgui.gui.guis.GuiItem;
import me.mattstudios.mfgui.gui.guis.GuiListener;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseGui
implements InventoryHolder {
    private static final Plugin plugin = JavaPlugin.getProvidingPlugin(BaseGui.class);
    private Inventory inventory;
    private final GuiFiller filler = new GuiFiller(this);
    private String title;
    private int rows;
    private GuiType guiType = GuiType.CHEST;
    private final Map<Integer, GuiItem> guiItems = new LinkedHashMap<Integer, GuiItem>();
    private final Map<Integer, GuiAction<InventoryClickEvent>> slotActions = new LinkedHashMap<Integer, GuiAction<InventoryClickEvent>>();
    private GuiAction<InventoryClickEvent> defaultClickAction;
    private GuiAction<InventoryClickEvent> defaultTopClickAction;
    private GuiAction<InventoryDragEvent> dragAction;
    private GuiAction<InventoryCloseEvent> closeGuiAction;
    private GuiAction<InventoryOpenEvent> openGuiAction;
    private GuiAction<InventoryClickEvent> outsideClickAction;
    private boolean updating;

    public BaseGui(int rows, @NotNull String title) {
        int finalRows = rows;
        if (rows < 1 || rows > 6) {
            finalRows = 1;
        }
        this.rows = finalRows;
        this.title = title;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(this.rows * 9), (String)title);
    }

    public BaseGui(@NotNull GuiType guiType, @NotNull String title) {
        this.title = title;
        this.guiType = guiType;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (InventoryType)guiType.getInventoryType(), (String)title);
    }

    public BaseGui setRows(int rows) {
        if (this.guiType != GuiType.CHEST) {
            throw new GuiException("Cannot set rows of non chest GUI!");
        }
        int finalRows = rows;
        if (rows < 1 || rows > 6) {
            finalRows = 1;
        }
        this.rows = finalRows;
        this.updating = true;
        ArrayList viewers = new ArrayList(this.inventory.getViewers());
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(this.rows * 9), (String)this.title);
        for (HumanEntity player : viewers) {
            this.open(player);
        }
        this.updating = false;
        return this;
    }

    public void setItem(int slot, @NotNull GuiItem guiItem) {
        this.validateSlot(slot);
        this.guiItems.put(slot, guiItem);
    }

    public void setItem(@NotNull List<Integer> slots, @NotNull GuiItem guiItem) {
        for (int slot : slots) {
            this.setItem(slot, guiItem);
        }
    }

    public void setItem(int row, int col, @NotNull GuiItem guiItem) {
        this.setItem(this.getSlotFromRowCol(row, col), guiItem);
    }

    public void addItem(GuiItem ... items) {
        block0: for (GuiItem guiItem : items) {
            for (int slot = 0; slot < this.rows * 9; ++slot) {
                if (this.guiItems.get(slot) != null) continue;
                this.guiItems.put(slot, guiItem);
                continue block0;
            }
        }
    }

    public void setDefaultClickAction(@Nullable GuiAction<InventoryClickEvent> defaultClickAction) {
        this.defaultClickAction = defaultClickAction;
    }

    public void setDefaultTopClickAction(@Nullable GuiAction<InventoryClickEvent> defaultTopClickAction) {
        this.defaultTopClickAction = defaultTopClickAction;
    }

    public void setOutsideClickAction(@Nullable GuiAction<InventoryClickEvent> outsideClickAction) {
        this.outsideClickAction = outsideClickAction;
    }

    public void setDragAction(@Nullable GuiAction<InventoryDragEvent> dragAction) {
        this.dragAction = dragAction;
    }

    public void setCloseGuiAction(@Nullable GuiAction<InventoryCloseEvent> closeGuiAction) {
        this.closeGuiAction = closeGuiAction;
    }

    public void setOpenGuiAction(@Nullable GuiAction<InventoryOpenEvent> openGuiAction) {
        this.openGuiAction = openGuiAction;
    }

    public void addSlotAction(int slot, @Nullable GuiAction<InventoryClickEvent> slotAction) {
        this.validateSlot(slot);
        this.slotActions.put(slot, slotAction);
    }

    public void addSlotAction(int row, int col, @Nullable GuiAction<InventoryClickEvent> slotAction) {
        this.addSlotAction(this.getSlotFromRowCol(row, col), slotAction);
    }

    @Nullable
    public GuiItem getGuiItem(int slot) {
        return this.guiItems.get(slot);
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public void setUpdating(boolean updating) {
        this.updating = updating;
    }

    public void open(@NotNull HumanEntity player) {
        Validate.notNull((Object)player, (String)"Player cannot be null when opening the GUI!");
        this.inventory.clear();
        this.populateGui();
        player.openInventory(this.inventory);
    }

    public void close(@NotNull HumanEntity player) {
        Validate.notNull((Object)player, (String)"Player cannot be null when closing the GUI!");
        Bukkit.getScheduler().runTaskLater(plugin, () -> ((HumanEntity)player).closeInventory(), 2L);
    }

    public void update() {
        this.inventory.clear();
        this.populateGui();
        for (HumanEntity viewer : new ArrayList(this.inventory.getViewers())) {
            ((Player)viewer).updateInventory();
        }
    }

    public void updateItem(int slot, @NotNull ItemStack itemStack) {
        if (!this.guiItems.containsKey(slot)) {
            return;
        }
        GuiItem guiItem = this.guiItems.get(slot);
        guiItem.setItemStack(itemStack);
        this.inventory.setItem(slot, guiItem.getItemStack());
    }

    public void updateItem(int row, int col, @NotNull ItemStack itemStack) {
        this.updateItem(this.getSlotFromRowCol(row, col), itemStack);
    }

    public void updateItem(int slot, @NotNull GuiItem item) {
        if (!this.guiItems.containsKey(slot)) {
            return;
        }
        this.guiItems.put(slot, item);
        this.inventory.setItem(slot, item.getItemStack());
    }

    public void updateItem(int row, int col, @NotNull GuiItem item) {
        this.updateItem(this.getSlotFromRowCol(row, col), item);
    }

    public BaseGui updateTitle(@NotNull String title) {
        this.title = title;
        this.updating = true;
        ArrayList viewers = new ArrayList(this.inventory.getViewers());
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.inventory.getSize(), (String)this.title);
        for (HumanEntity player : viewers) {
            this.open(player);
        }
        this.updating = false;
        return this;
    }

    @NotNull
    public GuiFiller getFiller() {
        return this.filler;
    }

    public Map<Integer, GuiItem> getGuiItems() {
        return Collections.unmodifiableMap(this.guiItems);
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public int getRows() {
        return this.rows;
    }

    @Nullable
    GuiAction<InventoryClickEvent> getDefaultClickAction() {
        return this.defaultClickAction;
    }

    @Nullable
    GuiAction<InventoryClickEvent> getDefaultTopClickAction() {
        return this.defaultTopClickAction;
    }

    @Nullable
    GuiAction<InventoryDragEvent> getDragAction() {
        return this.dragAction;
    }

    @Nullable
    GuiAction<InventoryCloseEvent> getCloseGuiAction() {
        return this.closeGuiAction;
    }

    @Nullable
    GuiAction<InventoryOpenEvent> getOpenGuiAction() {
        return this.openGuiAction;
    }

    @Nullable
    GuiAction<InventoryClickEvent> getOutsideClickAction() {
        return this.outsideClickAction;
    }

    @Nullable
    GuiAction<InventoryClickEvent> getSlotAction(int slot) {
        return this.slotActions.get(slot);
    }

    void populateGui() {
        for (Map.Entry<Integer, GuiItem> entry : this.getGuiItems().entrySet()) {
            this.getInventory().setItem(entry.getKey().intValue(), entry.getValue().getItemStack());
        }
    }

    int getSlotFromRowCol(int row, int col) {
        return col + (row - 1) * 9 - 1;
    }

    void setTitle(@NotNull String title) {
        this.title = title;
    }

    void setInventory(@NotNull Inventory inventory) {
        this.inventory = inventory;
    }

    private void validateSlot(int slot) {
        int limit = this.guiType.getLimit();
        if (this.guiType == GuiType.CHEST) {
            if (slot < 0 || slot >= this.rows * limit) {
                this.throwInvalidSlot(slot);
            }
            return;
        }
        if (slot < 0 || slot > limit) {
            this.throwInvalidSlot(slot);
        }
    }

    private void throwInvalidSlot(int slot) {
        throw new GuiException("Slot " + slot + " is not valid for the gui type - " + this.guiType.name() + "!");
    }

    static {
        Bukkit.getPluginManager().registerEvents((Listener)new GuiListener(), plugin);
    }
}

