/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfgui.gui.guis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.mattstudios.mfgui.gui.guis.BaseGui;
import me.mattstudios.mfgui.gui.guis.GuiItem;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PaginatedGui
extends BaseGui {
    private final List<GuiItem> pageItems = new ArrayList<GuiItem>();
    private final Map<Integer, GuiItem> currentPage = new LinkedHashMap<Integer, GuiItem>();
    private int pageSize;
    private int pageNum = 1;

    public PaginatedGui(int rows, int pageSize, @NotNull String title) {
        super(rows, title);
        this.pageSize = pageSize;
    }

    public PaginatedGui(int rows, @NotNull String title) {
        this(rows, 0, title);
    }

    public PaginatedGui(@NotNull String title) {
        this(2, title);
    }

    @Deprecated
    public PaginatedGui(@NotNull Plugin plugin, int rows, int pageSize, @NotNull String title) {
        super(rows, title);
        this.pageSize = pageSize;
        if (rows < 2) {
            this.setRows(2);
        }
    }

    @Deprecated
    public PaginatedGui(@NotNull Plugin plugin, int rows, @NotNull String title) {
        this(plugin, rows, 0, title);
    }

    @Deprecated
    public PaginatedGui(@NotNull Plugin plugin, @NotNull String title) {
        this(plugin, 2, title);
    }

    public BaseGui setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public void addItem(@NotNull GuiItem item) {
        this.pageItems.add(item);
    }

    @Override
    public void addItem(GuiItem ... items) {
        this.pageItems.addAll(Arrays.asList(items));
    }

    @Override
    public void update() {
        this.getInventory().clear();
        this.populateGui();
        this.updatePage();
    }

    public void updatePageItem(int slot, @NotNull ItemStack itemStack) {
        if (!this.currentPage.containsKey(slot)) {
            return;
        }
        GuiItem guiItem = this.currentPage.get(slot);
        guiItem.setItemStack(itemStack);
        this.getInventory().setItem(slot, guiItem.getItemStack());
    }

    public void updatePageItem(int row, int col, @NotNull ItemStack itemStack) {
        this.updateItem(this.getSlotFromRowCol(row, col), itemStack);
    }

    public void updatePageItem(int slot, @NotNull GuiItem item) {
        if (!this.currentPage.containsKey(slot)) {
            return;
        }
        this.currentPage.put(slot, item);
        this.getInventory().setItem(slot, item.getItemStack());
    }

    public void updatePageItem(int row, int col, @NotNull GuiItem item) {
        this.updateItem(this.getSlotFromRowCol(row, col), item);
    }

    @Override
    public void open(@NotNull HumanEntity player) {
        this.open(player, 1);
    }

    public void open(@NotNull HumanEntity player, int openPage) {
        if (openPage <= this.getPagesNum() || openPage > 0) {
            this.pageNum = openPage;
        }
        this.getInventory().clear();
        this.currentPage.clear();
        this.populateGui();
        if (this.pageSize == 0) {
            this.pageSize = this.calculatePageSize();
        }
        this.populatePage();
        player.openInventory(this.getInventory());
    }

    @Override
    public BaseGui updateTitle(@NotNull String title) {
        this.setTitle(title);
        this.setUpdating(true);
        ArrayList viewers = new ArrayList(this.getInventory().getViewers());
        this.setInventory(Bukkit.createInventory((InventoryHolder)this, (int)this.getInventory().getSize(), (String)title));
        for (HumanEntity player : viewers) {
            this.open(player, this.getCurrentPageNum());
        }
        this.setUpdating(false);
        return this;
    }

    public Map<Integer, GuiItem> getCurrentPageItems() {
        return Collections.unmodifiableMap(this.currentPage);
    }

    public List<GuiItem> getPageItems() {
        return Collections.unmodifiableList(this.pageItems);
    }

    public int getCurrentPageNum() {
        return this.pageNum;
    }

    public int getNextPageNum() {
        if (this.pageNum + 1 > this.getPagesNum()) {
            return this.pageNum;
        }
        return this.pageNum + 1;
    }

    public int getPrevPageNum() {
        if (this.pageNum - 1 == 0) {
            return this.pageNum;
        }
        return this.pageNum - 1;
    }

    public boolean next() {
        if (this.pageNum + 1 > this.getPagesNum()) {
            return false;
        }
        ++this.pageNum;
        this.updatePage();
        return true;
    }

    @Deprecated
    public boolean nextPage() {
        return this.next();
    }

    public boolean previous() {
        if (this.pageNum - 1 == 0) {
            return false;
        }
        --this.pageNum;
        this.updatePage();
        return true;
    }

    @Deprecated
    public boolean prevPage() {
        return this.previous();
    }

    GuiItem getPageItem(int slot) {
        return this.currentPage.get(slot);
    }

    private List<GuiItem> getPageNum(int givenPage) {
        int page = givenPage - 1;
        ArrayList<GuiItem> guiPage = new ArrayList<GuiItem>();
        int max = page * this.pageSize + this.pageSize;
        if (max > this.pageItems.size()) {
            max = this.pageItems.size();
        }
        for (int i = page * this.pageSize; i < max; ++i) {
            guiPage.add(this.pageItems.get(i));
        }
        return guiPage;
    }

    private int getPagesNum() {
        return (int)Math.ceil((double)this.pageItems.size() / (double)this.pageSize);
    }

    private void populatePage() {
        block0: for (GuiItem guiItem : this.getPageNum(this.pageNum)) {
            for (int slot = 0; slot < this.getRows() * 9; ++slot) {
                if (this.getInventory().getItem(slot) != null) continue;
                this.currentPage.put(slot, guiItem);
                this.getInventory().setItem(slot, guiItem.getItemStack());
                continue block0;
            }
        }
    }

    void clearPage() {
        for (Map.Entry<Integer, GuiItem> entry : this.currentPage.entrySet()) {
            this.getInventory().setItem(entry.getKey().intValue(), null);
        }
    }

    int getPageSize() {
        return this.pageSize;
    }

    int getPageNum() {
        return this.pageNum;
    }

    void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    void updatePage() {
        this.clearPage();
        this.populatePage();
    }

    int calculatePageSize() {
        int counter = 0;
        for (int slot = 0; slot < this.getRows() * 9; ++slot) {
            if (this.getInventory().getItem(slot) != null) continue;
            ++counter;
        }
        return counter;
    }
}

