/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfmsg.base;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import me.mattstudios.mfmsg.base.internal.Format;
import me.mattstudios.mfmsg.base.internal.color.FlatColor;
import me.mattstudios.mfmsg.base.internal.color.MessageColor;
import org.jetbrains.annotations.NotNull;

public final class FormatOptions {
    @NotNull
    private final Set<Format> formats;
    @NotNull
    private MessageColor defaultColor = new FlatColor("white");

    FormatOptions() {
        this.formats = EnumSet.allOf(Format.class);
    }

    @NotNull
    public static FormatOptions builder() {
        return new FormatOptions();
    }

    @NotNull
    public FormatOptions with(Format ... formats) {
        this.formats.clear();
        this.formats.addAll(Arrays.asList(formats));
        return this;
    }

    @NotNull
    public FormatOptions without(Format ... formats) {
        this.formats.removeAll(Arrays.asList(formats));
        return this;
    }

    @NotNull
    public FormatOptions defaultColor(@NotNull MessageColor defaultColor) {
        this.defaultColor = defaultColor;
        return this;
    }

    @NotNull
    MessageColor getDefaultColor() {
        return this.defaultColor;
    }

    @NotNull
    Set<Format> getFormats() {
        return this.formats;
    }
}

