/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfmsg.base;

import java.util.ArrayList;
import java.util.Set;
import me.mattstudios.mfmsg.base.FormatOptions;
import me.mattstudios.mfmsg.base.bukkit.BukkitComponent;
import me.mattstudios.mfmsg.base.internal.Format;
import me.mattstudios.mfmsg.base.internal.MessageComponent;
import me.mattstudios.mfmsg.base.internal.color.MessageColor;
import me.mattstudios.mfmsg.base.internal.component.MessageLine;
import me.mattstudios.mfmsg.base.internal.parser.MessageParser;
import me.mattstudios.mfmsg.base.internal.util.RegexUtils;
import org.jetbrains.annotations.NotNull;

public final class Message {
    @NotNull
    private final Set<Format> formats;
    @NotNull
    private final MessageColor defaultColor;

    private Message(@NotNull FormatOptions formatOptions) {
        this.formats = formatOptions.getFormats();
        this.defaultColor = formatOptions.getDefaultColor();
    }

    @NotNull
    public static Message create(@NotNull FormatOptions formatOptions) {
        return new Message(formatOptions);
    }

    @NotNull
    public static Message create() {
        return new Message(new FormatOptions());
    }

    public MessageComponent parse(@NotNull String message) {
        ArrayList<MessageLine> lines = new ArrayList<MessageLine>();
        for (String line : RegexUtils.splitNewLine(message)) {
            lines.add(new MessageLine(new MessageParser(line, this.formats, this.defaultColor).build()));
        }
        return new BukkitComponent(lines);
    }
}

