/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfmsg.base.bukkit.nms;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.UUID;
import me.mattstudios.mfmsg.base.bukkit.nms.ServerVersion;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class NmsMessage {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Class<?> CHAT_COMPONENT;
    private static final Class<?> CHAT_PACKET;
    private static final Class<?> TITLE_PACKET;
    private static Class CHAT_TYPE;
    private static final Class TITLE_TYPE;
    private static final MethodHandle CHAT_SERIALIZER;
    private static final MethodHandle PLAYER_HANDLE;
    private static final MethodHandle SEND_PACKET;
    private static final Field PLAYER_CONNECTION;

    public static void sendMessage(@NotNull Player player, @NotNull String message) {
        try {
            if (ServerVersion.CURRENT_VERSION.isOlderThan(ServerVersion.V1_12_R1)) {
                Object packet = LOOKUP.findConstructor(CHAT_PACKET, MethodType.methodType(Void.TYPE, CHAT_COMPONENT)).invokeWithArguments(CHAT_SERIALIZER.invokeWithArguments(message));
                NmsMessage.sendPacket(player, packet);
                return;
            }
            if (ServerVersion.CURRENT_VERSION.isColorLegacy()) {
                Object packet = LOOKUP.findConstructor(CHAT_PACKET, MethodType.methodType(Void.TYPE, CHAT_COMPONENT, CHAT_TYPE)).invokeWithArguments(CHAT_SERIALIZER.invokeWithArguments(message), Enum.valueOf(CHAT_TYPE, "CHAT"));
                NmsMessage.sendPacket(player, packet);
                return;
            }
            Object packet = LOOKUP.findConstructor(CHAT_PACKET, MethodType.methodType(Void.TYPE, CHAT_COMPONENT, CHAT_TYPE, UUID.class)).invokeWithArguments(CHAT_SERIALIZER.invoke(message), Enum.valueOf(CHAT_TYPE, "CHAT"), player.getUniqueId());
            NmsMessage.sendPacket(player, packet);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void sendTitle(@NotNull Player player, @NotNull String message, @NotNull TitleType titleType, int fadeIn, int stay, int fadeOut) {
        try {
            if (ServerVersion.CURRENT_VERSION.isOlderThan(ServerVersion.V1_12_R1) && titleType == TitleType.ACTIONBAR) {
                Object packet = LOOKUP.findConstructor(CHAT_PACKET, MethodType.methodType(Void.TYPE, CHAT_COMPONENT, Byte.TYPE)).invokeWithArguments(CHAT_SERIALIZER.invoke(message), (byte)2);
                NmsMessage.sendPacket(player, packet);
                return;
            }
            Object packet = LOOKUP.findConstructor(TITLE_PACKET, MethodType.methodType(Void.TYPE, TITLE_TYPE, CHAT_COMPONENT, Integer.TYPE, Integer.TYPE, Integer.TYPE)).invokeWithArguments(Enum.valueOf(TITLE_TYPE, titleType.name()), CHAT_SERIALIZER.invoke(message), fadeIn, stay, fadeOut);
            NmsMessage.sendPacket(player, packet);
            if (titleType == TitleType.SUBTITLE) {
                Object titlePacket = LOOKUP.findConstructor(TITLE_PACKET, MethodType.methodType(Void.TYPE, TITLE_TYPE, CHAT_COMPONENT, Integer.TYPE, Integer.TYPE, Integer.TYPE)).invokeWithArguments(Enum.valueOf(TITLE_TYPE, TitleType.TITLE.name()), null, fadeIn, stay, fadeOut);
                NmsMessage.sendPacket(player, titlePacket);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void sendPacket(@NotNull Player player, @NotNull Object packet) throws Throwable {
        Object playerConnection = PLAYER_CONNECTION.get(PLAYER_HANDLE.invoke(player));
        SEND_PACKET.invoke(playerConnection, packet);
    }

    @NotNull
    private static Class<?> getNmsClass(@NotNull String path) throws ClassNotFoundException {
        return Class.forName("net.minecraft.server." + ServerVersion.NMS_VERSION + "." + path);
    }

    @NotNull
    private static Class<?> getCraftClass(@NotNull String path) throws ClassNotFoundException {
        return Class.forName("org.bukkit.craftbukkit." + ServerVersion.NMS_VERSION + "." + path);
    }

    static {
        try {
            CHAT_COMPONENT = NmsMessage.getNmsClass("IChatBaseComponent");
            if (ServerVersion.CURRENT_VERSION.isOlderThan(ServerVersion.V1_12_R1)) {
                CHAT_SERIALIZER = LOOKUP.findStatic(NmsMessage.getNmsClass("IChatBaseComponent$ChatSerializer"), "a", MethodType.methodType(CHAT_COMPONENT, String.class));
            } else if (ServerVersion.CURRENT_VERSION.isLegacy()) {
                CHAT_SERIALIZER = LOOKUP.findStatic(NmsMessage.getNmsClass("IChatBaseComponent$ChatSerializer"), "a", MethodType.methodType(CHAT_COMPONENT, String.class));
                CHAT_TYPE = NmsMessage.getNmsClass("ChatMessageType");
            } else {
                CHAT_SERIALIZER = LOOKUP.findStatic(NmsMessage.getNmsClass("IChatBaseComponent$ChatSerializer"), "a", MethodType.methodType(NmsMessage.getNmsClass("IChatMutableComponent"), String.class));
                CHAT_TYPE = NmsMessage.getNmsClass("ChatMessageType");
            }
            TITLE_TYPE = NmsMessage.getNmsClass("PacketPlayOutTitle$EnumTitleAction");
            CHAT_PACKET = NmsMessage.getNmsClass("PacketPlayOutChat");
            TITLE_PACKET = NmsMessage.getNmsClass("PacketPlayOutTitle");
            Class<?> entityPlayerClass = NmsMessage.getNmsClass("EntityPlayer");
            PLAYER_HANDLE = LOOKUP.findVirtual(NmsMessage.getCraftClass("entity.CraftPlayer"), "getHandle", MethodType.methodType(entityPlayerClass));
            PLAYER_CONNECTION = entityPlayerClass.getField("playerConnection");
            Class<?> packetClass = NmsMessage.getNmsClass("Packet");
            Class<?> playerConnectionClass = PLAYER_CONNECTION.getType();
            SEND_PACKET = LOOKUP.findVirtual(playerConnectionClass, "sendPacket", MethodType.methodType(Void.TYPE, packetClass));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum TitleType {
        ACTIONBAR,
        TITLE,
        SUBTITLE;

    }
}

