/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfmsg.base.bukkit.nms;

import java.util.Arrays;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public enum ServerVersion {
    UNKNOWN(1000),
    V1_8_R1(81),
    V1_8_R2(82),
    V1_8_R3(83),
    V1_9_R1(91),
    V1_9_R2(92),
    V1_10_R1(101),
    V1_11_R1(111),
    V1_12_R1(121),
    V1_13_R1(131),
    V1_13_R2(132),
    V1_14_R1(141),
    V1_15_R1(151),
    V1_16_R1(161),
    V1_16_R2(162);

    private final int versionNumber;
    public static final String PACKAGE_NAME;
    public static final String NMS_VERSION;
    public static final ServerVersion CURRENT_VERSION;

    private ServerVersion(int versionNumber) {
        this.versionNumber = versionNumber;
    }

    public boolean isNewerThan(@NotNull ServerVersion version) {
        return this.versionNumber >= version.versionNumber;
    }

    public boolean isOlderThan(@NotNull ServerVersion version) {
        return this.versionNumber < version.versionNumber;
    }

    public boolean isLegacy() {
        return this.versionNumber < ServerVersion.V1_13_R1.versionNumber;
    }

    public boolean isColorLegacy() {
        return this.versionNumber < ServerVersion.V1_16_R1.versionNumber;
    }

    @NotNull
    public static ServerVersion getByNmsName(@NotNull String name) {
        return Arrays.stream(ServerVersion.values()).filter(version -> version.name().equalsIgnoreCase(name)).findFirst().orElse(UNKNOWN);
    }

    static {
        PACKAGE_NAME = Bukkit.getServer().getClass().getPackage().getName();
        NMS_VERSION = PACKAGE_NAME.substring(PACKAGE_NAME.lastIndexOf(46) + 1);
        CURRENT_VERSION = ServerVersion.getByNmsName(NMS_VERSION);
    }
}

