/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfmsg.base.internal;

import java.util.Set;
import me.mattstudios.mfmsg.base.internal.Format;
import me.mattstudios.mfmsg.base.internal.component.Appender;
import me.mattstudios.mfmsg.base.internal.extension.node.Obfuscated;
import me.mattstudios.mfmsg.base.internal.extension.node.Underline;
import org.commonmark.ext.gfm.strikethrough.Strikethrough;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.CustomNode;
import org.commonmark.node.Emphasis;
import org.commonmark.node.Node;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;

public final class MarkdownVisitor
extends AbstractVisitor {
    private final Set<Format> formats;
    private boolean bold;
    private boolean italic;
    private boolean strike;
    private boolean underline;
    private boolean obfuscated;
    private Appender appender;

    public MarkdownVisitor(Set<Format> formats) {
        this.formats = formats;
    }

    public void visitComponents(Node node, Appender appender) {
        if (this.appender != appender) {
            this.appender = appender;
        }
        node.accept(this);
    }

    @Override
    public void visit(Emphasis emphasis) {
        if (!this.formats.contains((Object)Format.ITALIC)) {
            this.visitChildren(emphasis);
            return;
        }
        this.italic = true;
        this.visitChildren(emphasis);
        this.italic = false;
    }

    @Override
    public void visit(StrongEmphasis strongEmphasis) {
        if (!this.formats.contains((Object)Format.BOLD)) {
            this.visitChildren(strongEmphasis);
            return;
        }
        this.bold = true;
        this.visitChildren(strongEmphasis);
        this.bold = false;
    }

    @Override
    public void visit(CustomNode customNode) {
        if (customNode instanceof Underline) {
            if (!this.formats.contains((Object)Format.UNDERLINE)) {
                this.visitChildren(customNode);
                return;
            }
            this.underline = true;
            this.visitChildren(customNode);
            this.underline = false;
            return;
        }
        if (customNode instanceof Obfuscated) {
            if (!this.formats.contains((Object)Format.OBFUSCATED)) {
                this.visitChildren(customNode);
                return;
            }
            this.obfuscated = true;
            this.visitChildren(customNode);
            this.obfuscated = false;
            return;
        }
        if (!(customNode instanceof Strikethrough)) {
            return;
        }
        if (!this.formats.contains((Object)Format.STRIKETHROUGH)) {
            this.visitChildren(customNode);
            return;
        }
        this.strike = true;
        this.visitChildren(customNode);
        this.strike = false;
    }

    @Override
    public void visit(Text text) {
        this.appender.append(text.getLiteral(), this.italic, this.bold, this.strike, this.underline, this.obfuscated);
        this.visitChildren(text);
    }
}

