/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfmsg.base.internal.color.handler;

import com.google.common.primitives.Floats;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import me.mattstudios.mfmsg.base.bukkit.nms.ServerVersion;
import me.mattstudios.mfmsg.base.internal.Format;
import me.mattstudios.mfmsg.base.internal.action.Action;
import me.mattstudios.mfmsg.base.internal.color.FlatColor;
import me.mattstudios.mfmsg.base.internal.color.Gradient;
import me.mattstudios.mfmsg.base.internal.color.MessageColor;
import me.mattstudios.mfmsg.base.internal.color.Rainbow;
import me.mattstudios.mfmsg.base.internal.color.handler.ColorMapping;
import me.mattstudios.mfmsg.base.internal.component.MessagePart;
import me.mattstudios.mfmsg.base.internal.util.RegexUtils;
import org.jetbrains.annotations.NotNull;

public final class ColorHandler {
    private final Set<Format> formats;
    private final MessageColor defaultColor;
    private MessageColor currentColor;

    public ColorHandler(@NotNull Set<Format> formats, @NotNull MessageColor defaultColor) {
        this.formats = formats;
        this.defaultColor = defaultColor;
        this.currentColor = defaultColor;
    }

    @NotNull
    public List<MessagePart> colorize(@NotNull String message, boolean bold, boolean italic, boolean strike, boolean underline, boolean obfuscated, @NotNull List<Action> actions) {
        ArrayList<MessagePart> parts = new ArrayList<MessagePart>();
        Matcher matcher = RegexUtils.COLOR_PATTERN.matcher(message);
        String rest = message;
        int start = 0;
        while (matcher.find()) {
            String gradient;
            String hex;
            String colorChar;
            String before = message.substring(start, matcher.start());
            if (!before.isEmpty()) {
                parts.add(new MessagePart(before, this.currentColor, bold, italic, strike, underline, obfuscated, actions));
            }
            if ((colorChar = matcher.group("char")) != null) {
                if (this.formats.contains((Object)Format.COLOR)) {
                    this.currentColor = new FlatColor(ColorMapping.fromChar(colorChar.charAt(0)));
                } else if ("r".equalsIgnoreCase(colorChar)) {
                    this.currentColor = this.defaultColor;
                }
            }
            if ((hex = matcher.group("hex")) != null && this.formats.contains((Object)Format.HEX)) {
                this.currentColor = new FlatColor(this.ofHex(hex));
            }
            if ((gradient = matcher.group("gradient")) != null && !ServerVersion.CURRENT_VERSION.isColorLegacy() && this.formats.contains((Object)Format.GRADIENT)) {
                List<String> colors = Arrays.asList(gradient.split(":"));
                this.currentColor = colors.size() == 1 ? new FlatColor(this.ofHex(colors.get(0))) : new Gradient(colors.stream().map(this::hexToColor).collect(Collectors.toList()));
            }
            if (matcher.group("r") != null && !ServerVersion.CURRENT_VERSION.isColorLegacy() && this.formats.contains((Object)Format.RAINBOW)) {
                Float light;
                Float sat;
                String satString = matcher.group("sat");
                String ligString = matcher.group("lig");
                float saturation = 1.0f;
                float brightness = 1.0f;
                if (satString != null && (sat = Floats.tryParse((String)satString.substring(1))) != null && (double)sat.floatValue() <= 1.0 && (double)sat.floatValue() >= 0.0) {
                    saturation = sat.floatValue();
                }
                if (ligString != null && (light = Floats.tryParse((String)ligString.substring(1))) != null && (double)light.floatValue() <= 1.0 && (double)light.floatValue() >= 0.0) {
                    brightness = light.floatValue();
                }
                this.currentColor = new Rainbow(saturation, brightness);
            }
            start = matcher.end();
            rest = message.substring(start);
        }
        if (!rest.isEmpty()) {
            parts.add(new MessagePart(rest, this.currentColor, bold, italic, strike, underline, obfuscated, actions));
        }
        return parts;
    }

    @NotNull
    private String ofHex(@NotNull String color) {
        if (ServerVersion.CURRENT_VERSION.isColorLegacy()) {
            return ColorMapping.toLegacy(this.hexToColor(color));
        }
        return "#" + Integer.toHexString(this.hexToColor(color).getRGB()).substring(2);
    }

    @NotNull
    private Color hexToColor(@NotNull String color) {
        StringBuilder builder = new StringBuilder();
        String hex = color.substring(1);
        builder.append("#");
        if (hex.length() == 6) {
            builder.append(hex);
        } else {
            builder.append(this.increaseHex(hex.substring(0, 3)));
        }
        return Color.decode(builder.toString());
    }

    @NotNull
    private String increaseHex(@NotNull String hex) {
        return RegexUtils.THREE_HEX.matcher(hex).replaceAll("$1$1$2$2$3$3");
    }
}

