/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfmsg.base.internal.color.handler;

import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public enum ColorMapping {
    BLACK(0, "black", '0'),
    DARK_BLUE(170, "dark_blue", '1'),
    DARK_GREEN(43520, "dark_green", '2'),
    DARK_AQUA(43690, "dark_aqua", '3'),
    DARK_RED(0xAA0000, "dark_red", '4'),
    DARK_PURPLE(0xAA00AA, "dark_purple", '5'),
    GOLD(0xFFAA00, "gold", '6'),
    GRAY(0xAAAAAA, "gray", '7'),
    DARK_GRAY(0x555555, "dark_gray", '8'),
    BLUE(0x5555FF, "blue", '9'),
    GREEN(0x55FF55, "green", 'a'),
    AQUA(0x55FFFF, "aqua", 'b'),
    RED(0xFF5555, "red", 'c'),
    LIGHT_PURPLE(0xFF55FF, "light_purple", 'd'),
    YELLOW(0xFFFF55, "yellow", 'e'),
    WHITE(0xFFFFFF, "white", 'f');

    private final int r;
    private final int g;
    private final int b;
    private final char character;
    private final String colorName;

    private ColorMapping(int hex, String colorName, char character) {
        this.r = hex >> 16 & 0xFF;
        this.g = hex >> 8 & 0xFF;
        this.b = hex & 0xFF;
        this.colorName = colorName;
        this.character = character;
    }

    @NotNull
    public static String fromChar(char character) {
        for (ColorMapping mapping : ColorMapping.values()) {
            if (mapping.character != character) continue;
            return mapping.colorName;
        }
        return ColorMapping.WHITE.colorName;
    }

    public static char fromName(@NotNull String colorName) {
        for (ColorMapping mapping : ColorMapping.values()) {
            if (!mapping.colorName.equalsIgnoreCase(colorName)) continue;
            return mapping.character;
        }
        return ColorMapping.WHITE.character;
    }

    @NotNull
    public static String toLegacy(@NotNull Color color) {
        int minDist = Integer.MAX_VALUE;
        String legacy = ColorMapping.WHITE.colorName;
        for (ColorMapping mapping : ColorMapping.values()) {
            int b;
            int g;
            int r = mapping.r - color.getRed();
            int dist = r * r + (g = mapping.g - color.getGreen()) * g + (b = mapping.b - color.getBlue()) * b;
            if (dist >= minDist) continue;
            minDist = dist;
            legacy = mapping.colorName;
        }
        return legacy;
    }
}

