/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfmsg.base.internal.color.handler;

import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class GradientHandler {
    @NotNull
    private final List<Color> colors;
    private final int stepSize;
    private int step = 0;
    private int stepIndex = 0;

    public GradientHandler(@NotNull List<Color> colors, int totalColors) {
        this.colors = colors;
        this.stepSize = totalColors / (colors.size() - 1);
    }

    @NotNull
    public String next() {
        Color color;
        if (this.stepIndex + 1 < this.colors.size()) {
            Color start = this.colors.get(this.stepIndex);
            Color end = this.colors.get(this.stepIndex + 1);
            float interval = (float)this.step / (float)this.stepSize;
            color = GradientHandler.getGradientInterval(start, end, interval);
        } else {
            color = this.colors.get(this.colors.size() - 1);
        }
        ++this.step;
        if (this.step >= this.stepSize) {
            this.step = 0;
            ++this.stepIndex;
        }
        return "#" + Integer.toHexString(color.getRGB()).substring(2);
    }

    @NotNull
    private static Color getGradientInterval(@NotNull Color start, @NotNull Color end, float interval) {
        int r = (int)((float)end.getRed() * interval + (float)start.getRed() * (1.0f - interval));
        int g = (int)((float)end.getGreen() * interval + (float)start.getGreen() * (1.0f - interval));
        int b = (int)((float)end.getBlue() * interval + (float)start.getBlue() * (1.0f - interval));
        return new Color(r, g, b);
    }
}

