/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfmsg.base.internal.component;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.mattstudios.mfmsg.base.internal.Format;
import me.mattstudios.mfmsg.base.internal.action.Action;
import me.mattstudios.mfmsg.base.internal.color.MessageColor;
import me.mattstudios.mfmsg.base.internal.color.handler.ColorHandler;
import me.mattstudios.mfmsg.base.internal.component.Appender;
import me.mattstudios.mfmsg.base.internal.component.MessagePart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MessageAppender
implements Appender {
    private final ColorHandler colorHandler;
    @NotNull
    private final List<MessagePart> parts = new ArrayList<MessagePart>();
    @NotNull
    private final List<Action> actions = new ArrayList<Action>();

    public MessageAppender(@NotNull Set<Format> formats, @NotNull MessageColor defaultColor) {
        this.colorHandler = new ColorHandler(formats, defaultColor);
    }

    @Override
    public void append(@NotNull String message, boolean italic, boolean bold, boolean strike, boolean underline, boolean obfuscated) {
        this.parts.addAll(this.colorHandler.colorize(message, bold, italic, strike, underline, obfuscated, new ArrayList<Action>(this.actions)));
    }

    @Override
    public void addActions(@Nullable List<Action> actions) {
        if (actions == null) {
            return;
        }
        this.actions.addAll(actions);
    }

    @Override
    @NotNull
    public List<MessagePart> build() {
        ArrayList<MessagePart> test = new ArrayList<MessagePart>(this.parts);
        this.reset();
        return test;
    }

    private void reset() {
        this.parts.clear();
        this.actions.clear();
    }
}

