/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfmsg.base.internal.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import me.mattstudios.mfmsg.base.internal.Format;
import me.mattstudios.mfmsg.base.internal.MarkdownVisitor;
import me.mattstudios.mfmsg.base.internal.action.Action;
import me.mattstudios.mfmsg.base.internal.action.ClickAction;
import me.mattstudios.mfmsg.base.internal.action.HoverAction;
import me.mattstudios.mfmsg.base.internal.color.MessageColor;
import me.mattstudios.mfmsg.base.internal.component.Appender;
import me.mattstudios.mfmsg.base.internal.component.MessageAppender;
import me.mattstudios.mfmsg.base.internal.component.MessageLine;
import me.mattstudios.mfmsg.base.internal.component.MessagePart;
import me.mattstudios.mfmsg.base.internal.extension.ObfuscatedExtension;
import me.mattstudios.mfmsg.base.internal.extension.UnderlineExtension;
import me.mattstudios.mfmsg.base.internal.token.ActionLexer;
import me.mattstudios.mfmsg.base.internal.token.ActionToken;
import me.mattstudios.mfmsg.base.internal.token.SpaceToken;
import me.mattstudios.mfmsg.base.internal.token.TextToken;
import me.mattstudios.mfmsg.base.internal.token.Token;
import me.mattstudios.mfmsg.base.internal.util.RegexUtils;
import org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.jetbrains.annotations.NotNull;

public final class MessageParser {
    private static final Parser PARSER = Parser.builder().extensions(Arrays.asList(StrikethroughExtension.create(), UnderlineExtension.create(), ObfuscatedExtension.create())).build();
    @NotNull
    private final List<Token> tokens;
    @NotNull
    private final Set<Format> formats;
    @NotNull
    private final MessageColor defaultColor;
    @NotNull
    private final List<MessagePart> parts = new ArrayList<MessagePart>();
    @NotNull
    private final Appender appender;
    @NotNull
    private final MarkdownVisitor visitor;

    public MessageParser(@NotNull String message, @NotNull Set<Format> formats, @NotNull MessageColor defaultColor) {
        this.formats = formats;
        this.defaultColor = defaultColor;
        this.appender = new MessageAppender(formats, defaultColor);
        this.visitor = new MarkdownVisitor(formats);
        this.tokens = ActionLexer.tokenize(message);
        this.parseTokens();
    }

    private void parseTokens() {
        for (Token token : this.tokens) {
            if (token instanceof ActionToken) {
                this.parseAction((ActionToken)token);
                continue;
            }
            if (token instanceof SpaceToken) {
                this.appender.append(((SpaceToken)token).getText(), false, false, false, false, false);
                this.parts.addAll(this.appender.build());
                continue;
            }
            String tokenText = ((TextToken)token).getText();
            if (tokenText.isEmpty()) continue;
            this.visit(PARSER.parse(tokenText));
            this.parts.addAll(this.appender.build());
        }
    }

    private void visit(Node node) {
        this.visitor.visitComponents(node, this.appender);
    }

    private void parseAction(@NotNull ActionToken token) {
        ArrayList<Action> actions = new ArrayList<Action>(2);
        block14: for (String action : RegexUtils.SPLIT_PATTERN.split(token.getActions())) {
            Matcher matcher = RegexUtils.ACTION_PATTERN.matcher(action);
            if (!matcher.find()) continue;
            String actionText = matcher.group("text").trim();
            switch (matcher.group("type").toLowerCase()) {
                case "hover": {
                    if (!this.formats.contains((Object)Format.ACTION_HOVER)) continue block14;
                    ArrayList<MessageLine> lines = new ArrayList<MessageLine>();
                    for (String line : RegexUtils.NEW_LINE.split(actionText)) {
                        MessageAppender appender = new MessageAppender(this.formats, this.defaultColor);
                        this.visitor.visitComponents(PARSER.parse(line), appender);
                        lines.add(new MessageLine(appender.build()));
                    }
                    actions.add(new HoverAction(lines));
                    continue block14;
                }
                case "command": {
                    if (!this.formats.contains((Object)Format.ACTION_COMMAND)) continue block14;
                    actions.add(new ClickAction(Format.ACTION_COMMAND, actionText));
                    continue block14;
                }
                case "suggest": {
                    if (!this.formats.contains((Object)Format.ACTION_SUGGEST)) continue block14;
                    actions.add(new ClickAction(Format.ACTION_SUGGEST, actionText));
                    continue block14;
                }
                case "clipboard": {
                    if (!this.formats.contains((Object)Format.ACTION_CLIPBOARD)) continue block14;
                    actions.add(new ClickAction(Format.ACTION_CLIPBOARD, actionText));
                    continue block14;
                }
                case "url": {
                    if (!this.formats.contains((Object)Format.ACTION_URL)) continue block14;
                    actions.add(new ClickAction(Format.ACTION_URL, actionText));
                }
            }
        }
        this.appender.addActions(actions);
        this.visit(PARSER.parse(token.getActionText()));
        List<MessagePart> parts = this.appender.build();
        if (parts.isEmpty()) {
            return;
        }
        this.parts.addAll(parts);
    }

    public List<MessagePart> build() {
        return this.parts;
    }
}

