/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfmsg.base.internal.token;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import me.mattstudios.mfmsg.base.internal.token.ActionToken;
import me.mattstudios.mfmsg.base.internal.token.SpaceToken;
import me.mattstudios.mfmsg.base.internal.token.TextToken;
import me.mattstudios.mfmsg.base.internal.token.Token;
import me.mattstudios.mfmsg.base.internal.util.RegexUtils;
import org.jetbrains.annotations.NotNull;

public final class ActionLexer {
    private ActionLexer() {
    }

    @NotNull
    public static List<Token> tokenize(@NotNull String message) {
        LinkedList<Token> tokens = new LinkedList<Token>();
        Matcher matcher = RegexUtils.ACTION_PATTERN_SPACES.matcher(message);
        String rest = message;
        int start = 0;
        while (matcher.find()) {
            String startSpaces;
            String before = message.substring(start, matcher.start());
            if (!before.isEmpty()) {
                tokens.add(new TextToken(before));
            }
            if ((startSpaces = matcher.group("start")) != null && !startSpaces.isEmpty()) {
                tokens.add(new SpaceToken(startSpaces));
            }
            String actionText = matcher.group("text");
            String actions = matcher.group("actions");
            tokens.add(new ActionToken(actionText, actions));
            String endSpaces = matcher.group("end");
            if (endSpaces != null && !endSpaces.isEmpty()) {
                tokens.add(new SpaceToken(endSpaces));
            }
            start = matcher.end();
            rest = message.substring(start);
        }
        if (!rest.isEmpty()) {
            tokens.add(new TextToken(rest));
        }
        return tokens;
    }
}

