/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfmsg.base.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class RegexUtils {
    public static final Pattern COLOR_PATTERN = Pattern.compile("(?<!\\\\)[<&](?<hex>#[A-Fa-f0-9]{3,6})[>]?|(?<!\\\\)&(?<char>[a-fA-F0-9rR])|<(?:g|gradient):(?<gradient>.+?)>|<(?<r>r|rainbow)(?<sat>:\\d*\\.\\d*)?(?<lig>:\\d*\\.\\d*)?>");
    public static final Pattern THREE_HEX = Pattern.compile("([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])");
    public static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!\\\\)\\|");
    public static final Pattern ACTION_PATTERN = Pattern.compile("^(?<type>\\w+):(?<text>.*)");
    public static final Pattern NEW_LINE = Pattern.compile("\\r?\\\\n");
    public static final Pattern ACTION_PATTERN_SPACES = Pattern.compile("((?<start>[ ]*)((?<!\\\\)\\[(?<text>.+?)(?<!\\\\)](?<!\\\\)\\((?<actions>.+?)(?<!\\\\)\\))(?<end>[ ]*))");
    public static final Pattern CHARACTER = Pattern.compile(".");
    private static final Pattern NEW_LINE_ACTION = Pattern.compile("(?<action>\\[[^]]*]\\([^)]*\\))|(?<break>\\r?\\\\n)");

    private RegexUtils() {
    }

    @NotNull
    public static List<String> splitNewLine(@NotNull String message) {
        ArrayList<String> lines = new ArrayList<String>();
        Matcher matcher = NEW_LINE_ACTION.matcher(message);
        String rest = message;
        int start = 0;
        while (matcher.find()) {
            if (matcher.group("action") != null) continue;
            String before = message.substring(start, matcher.start());
            if (!before.isEmpty()) {
                lines.add(before.trim());
            }
            start = matcher.end();
            rest = message.substring(start);
        }
        if (!rest.isEmpty()) {
            lines.add(rest.trim());
        }
        return lines;
    }
}

