/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfmsg.base.serializer;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.mattstudios.mfmsg.base.bukkit.nms.ServerVersion;
import me.mattstudios.mfmsg.base.internal.action.Action;
import me.mattstudios.mfmsg.base.internal.action.ClickAction;
import me.mattstudios.mfmsg.base.internal.action.HoverAction;
import me.mattstudios.mfmsg.base.internal.color.FlatColor;
import me.mattstudios.mfmsg.base.internal.color.Gradient;
import me.mattstudios.mfmsg.base.internal.color.MessageColor;
import me.mattstudios.mfmsg.base.internal.color.Rainbow;
import me.mattstudios.mfmsg.base.internal.color.handler.GradientHandler;
import me.mattstudios.mfmsg.base.internal.color.handler.RainbowHandler;
import me.mattstudios.mfmsg.base.internal.component.MessageLine;
import me.mattstudios.mfmsg.base.internal.component.MessagePart;
import org.jetbrains.annotations.NotNull;

public final class JsonSerializer {
    @NotNull
    private static final Gson gson = new Gson();

    private JsonSerializer() {
    }

    @NotNull
    public static String toString(@NotNull List<MessageLine> lines) {
        return gson.toJson((JsonElement)JsonSerializer.toJson(lines));
    }

    @NotNull
    public static JsonArray toJson(@NotNull List<MessageLine> lines) {
        JsonArray jsonArray = new JsonArray();
        Iterator<MessageLine> iterator = lines.iterator();
        while (iterator.hasNext()) {
            jsonArray.add((JsonElement)JsonSerializer.convertLine(iterator.next().getParts()));
            if (!iterator.hasNext()) continue;
            JsonObject newLine = new JsonObject();
            newLine.addProperty("text", "\n");
            jsonArray.add((JsonElement)newLine);
        }
        return jsonArray;
    }

    @NotNull
    private static JsonArray convertLine(@NotNull List<MessagePart> parts) {
        JsonArray jsonArray = new JsonArray();
        for (int i = 0; i < parts.size(); ++i) {
            MessagePart newPart;
            MessagePart part = parts.get(i);
            MessageColor color = part.getColor();
            if (color instanceof Gradient) {
                ArrayList<MessagePart> gradientParts = new ArrayList<MessagePart>();
                Gradient gradient = (Gradient)color;
                gradientParts.add(part);
                while (i + 1 < parts.size() && color.equals((newPart = parts.get(i + 1)).getColor())) {
                    gradientParts.add(newPart);
                    ++i;
                }
                jsonArray.addAll(JsonSerializer.toGradient(gradientParts, gradient));
                continue;
            }
            if (color instanceof Rainbow) {
                ArrayList<MessagePart> rainbowParts = new ArrayList<MessagePart>();
                Rainbow rainbow = (Rainbow)color;
                rainbowParts.add(part);
                while (i + 1 < parts.size() && color.equals((newPart = parts.get(i + 1)).getColor())) {
                    rainbowParts.add(newPart);
                    ++i;
                }
                jsonArray.addAll(JsonSerializer.toRainbow(rainbowParts, rainbow));
                continue;
            }
            String colorString = null;
            if (color != null) {
                colorString = ((FlatColor)color).getColor();
            }
            jsonArray.add((JsonElement)JsonSerializer.serializePart(part.getText(), colorString, part.isBold(), part.isItalic(), part.isStrike(), part.isUnderlined(), part.isObfuscated(), part.getActions()));
        }
        return jsonArray;
    }

    @NotNull
    public static JsonObject serializePart(@NotNull String text, @NotNull String color, boolean bold, boolean italic, boolean strike, boolean underline, boolean obfuscated, @NotNull List<Action> actions) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("text", text);
        jsonObject.addProperty("bold", Boolean.valueOf(bold));
        jsonObject.addProperty("italic", Boolean.valueOf(italic));
        jsonObject.addProperty("strikethrough", Boolean.valueOf(strike));
        jsonObject.addProperty("underlined", Boolean.valueOf(underline));
        jsonObject.addProperty("obfuscated", Boolean.valueOf(obfuscated));
        jsonObject.addProperty("color", color);
        if (actions.isEmpty()) {
            return jsonObject;
        }
        for (Action action : actions) {
            if (action instanceof HoverAction) {
                JsonObject hoverObject = new JsonObject();
                hoverObject.addProperty("action", "show_text");
                if (ServerVersion.CURRENT_VERSION.isColorLegacy()) {
                    hoverObject.add("value", (JsonElement)JsonSerializer.toJson(((HoverAction)action).getLines()));
                } else {
                    hoverObject.add("contents", (JsonElement)JsonSerializer.toJson(((HoverAction)action).getLines()));
                }
                jsonObject.add("hoverEvent", (JsonElement)hoverObject);
                continue;
            }
            ClickAction clickAction = (ClickAction)action;
            switch (clickAction.getActionType()) {
                case ACTION_COMMAND: {
                    jsonObject.add("clickEvent", (JsonElement)JsonSerializer.getClickEvent(clickAction, "run_command"));
                    break;
                }
                case ACTION_SUGGEST: {
                    jsonObject.add("clickEvent", (JsonElement)JsonSerializer.getClickEvent(clickAction, "suggest_command"));
                    break;
                }
                case ACTION_URL: {
                    jsonObject.add("clickEvent", (JsonElement)JsonSerializer.getClickEvent(clickAction, "open_url"));
                    break;
                }
                case ACTION_CLIPBOARD: {
                    jsonObject.add("clickEvent", (JsonElement)JsonSerializer.getClickEvent(clickAction, "copy_to_clipboard"));
                }
            }
        }
        return jsonObject;
    }

    @NotNull
    private static JsonArray toGradient(@NotNull List<MessagePart> parts, @NotNull Gradient gradient) {
        JsonArray jsonArray = new JsonArray();
        int length = parts.stream().mapToInt(part -> part.getText().length()).sum();
        List<Color> colors = gradient.getColors();
        GradientHandler gradientHandler = new GradientHandler(colors, length);
        for (MessagePart part2 : parts) {
            for (char character : part2.getText().toCharArray()) {
                jsonArray.add((JsonElement)JsonSerializer.serializePart(String.valueOf(character), gradientHandler.next(), part2.isBold(), part2.isItalic(), part2.isStrike(), part2.isUnderlined(), part2.isObfuscated(), part2.getActions()));
            }
        }
        return jsonArray;
    }

    @NotNull
    private static JsonArray toRainbow(@NotNull List<MessagePart> parts, @NotNull Rainbow rainbow) {
        JsonArray jsonArray = new JsonArray();
        int length = parts.stream().mapToInt(part -> part.getText().length()).sum();
        RainbowHandler rainbowHandler = new RainbowHandler(length, rainbow.getSaturation(), rainbow.getBrightness());
        for (MessagePart part2 : parts) {
            for (char character : part2.getText().toCharArray()) {
                jsonArray.add((JsonElement)JsonSerializer.serializePart(String.valueOf(character), rainbowHandler.next(), part2.isBold(), part2.isItalic(), part2.isStrike(), part2.isUnderlined(), part2.isObfuscated(), part2.getActions()));
            }
        }
        return jsonArray;
    }

    @NotNull
    private static JsonObject getClickEvent(@NotNull ClickAction clickAction, @NotNull String type) {
        JsonObject clickObject = new JsonObject();
        clickObject.addProperty("action", type);
        clickObject.addProperty("value", clickAction.getAction());
        return clickObject;
    }
}

