/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfmsg.base.serializer;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.mattstudios.mfmsg.base.internal.color.FlatColor;
import me.mattstudios.mfmsg.base.internal.color.Gradient;
import me.mattstudios.mfmsg.base.internal.color.MessageColor;
import me.mattstudios.mfmsg.base.internal.color.Rainbow;
import me.mattstudios.mfmsg.base.internal.color.handler.ColorMapping;
import me.mattstudios.mfmsg.base.internal.color.handler.GradientHandler;
import me.mattstudios.mfmsg.base.internal.color.handler.RainbowHandler;
import me.mattstudios.mfmsg.base.internal.component.MessageLine;
import me.mattstudios.mfmsg.base.internal.component.MessagePart;
import me.mattstudios.mfmsg.base.internal.util.RegexUtils;
import org.jetbrains.annotations.NotNull;

public final class StringSerializer {
    private StringSerializer() {
    }

    @NotNull
    public static String toString(@NotNull List<MessageLine> lines) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<MessageLine> iterator = lines.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(StringSerializer.convertLine(iterator.next().getParts()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    @NotNull
    private static String convertLine(@NotNull List<MessagePart> parts) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < parts.size(); ++i) {
            MessagePart newPart;
            MessagePart part = parts.get(i);
            MessageColor color = part.getColor();
            if (color instanceof Gradient) {
                ArrayList<MessagePart> gradientParts = new ArrayList<MessagePart>();
                Gradient gradient = (Gradient)color;
                gradientParts.add(part);
                while (i + 1 < parts.size() && color.equals((newPart = parts.get(i + 1)).getColor())) {
                    gradientParts.add(newPart);
                    ++i;
                }
                stringBuilder.append(StringSerializer.toGradient(gradientParts, gradient));
                continue;
            }
            if (color instanceof Rainbow) {
                ArrayList<MessagePart> rainbowParts = new ArrayList<MessagePart>();
                Rainbow rainbow = (Rainbow)color;
                rainbowParts.add(part);
                while (i + 1 < parts.size() && color.equals((newPart = parts.get(i + 1)).getColor())) {
                    rainbowParts.add(newPart);
                    ++i;
                }
                stringBuilder.append(StringSerializer.toRainbow(rainbowParts, rainbow));
                continue;
            }
            String colorString = ((FlatColor)color).getColor();
            stringBuilder.append(StringSerializer.serializePart(part.getText(), colorString, part.isBold(), part.isItalic(), part.isStrike(), part.isUnderlined(), part.isObfuscated()));
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static String serializePart(@NotNull String text, @NotNull String color, boolean bold, boolean italic, boolean strike, boolean underline, boolean obfuscated) {
        StringBuilder stringBuilder = new StringBuilder();
        if (color.startsWith("#")) {
            stringBuilder.append("\u00a7x").append(RegexUtils.CHARACTER.matcher(color.substring(1)).replaceAll("\u00a7$0"));
        } else {
            stringBuilder.append("\u00a7").append(ColorMapping.fromName(color));
        }
        if (bold) {
            stringBuilder.append("\u00a7l");
        }
        if (italic) {
            stringBuilder.append("\u00a7o");
        }
        if (strike) {
            stringBuilder.append("\u00a7m");
        }
        if (underline) {
            stringBuilder.append("\u00a7n");
        }
        if (obfuscated) {
            stringBuilder.append("\u00a7k");
        }
        stringBuilder.append(text);
        stringBuilder.append("\u00a7r");
        return stringBuilder.toString();
    }

    @NotNull
    public static String toGradient(@NotNull List<MessagePart> parts, @NotNull Gradient gradient) {
        StringBuilder stringBuilder = new StringBuilder();
        int length = parts.stream().mapToInt(part -> part.getText().length()).sum();
        List<Color> colors = gradient.getColors();
        GradientHandler gradientHandler = new GradientHandler(colors, length);
        for (MessagePart part2 : parts) {
            for (char character : part2.getText().toCharArray()) {
                stringBuilder.append(StringSerializer.serializePart(String.valueOf(character), gradientHandler.next(), part2.isBold(), part2.isItalic(), part2.isStrike(), part2.isUnderlined(), part2.isObfuscated()));
            }
        }
        return stringBuilder.toString();
    }

    @NotNull
    private static String toRainbow(@NotNull List<MessagePart> parts, @NotNull Rainbow rainbow) {
        StringBuilder stringBuilder = new StringBuilder();
        int length = parts.stream().mapToInt(part -> part.getText().length()).sum();
        RainbowHandler rainbowHandler = new RainbowHandler(length, rainbow.getSaturation(), rainbow.getBrightness());
        for (MessagePart part2 : parts) {
            for (char character : part2.getText().toCharArray()) {
                stringBuilder.append(StringSerializer.serializePart(String.valueOf(character), rainbowHandler.next(), part2.isBold(), part2.isItalic(), part2.isStrike(), part2.isUnderlined(), part2.isObfuscated()));
            }
        }
        return stringBuilder.toString();
    }
}

