/*
 * Decompiled with CFR 0.152.
 */
package me.meilon.jsftp.client;

import me.meilon.jsftp.client.excetpion.SftpClientRunException;
import me.meilon.jsftp.client.function.JsftpConsumer;
import me.meilon.jsftp.client.function.JsftpFunction;
import me.meilon.jsftp.core.SftpConnect;
import me.meilon.jsftp.core.SftpPool;
import me.meilon.jsftp.core.conf.SftpConnConfig;

public class JsftpClient {
    protected final SftpPool pool;
    protected final SftpConnConfig config;

    public JsftpClient(SftpPool pool, SftpConnConfig config) {
        this.pool = pool;
        this.config = config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <P> P run(JsftpFunction<P> function) {
        try (SftpConnect sftp = this.pool.borrowObject(this.config);){
            P p = function.apply(sftp);
            return p;
        }
        catch (Exception e) {
            throw new SftpClientRunException(e);
        }
    }

    public void run(JsftpConsumer fun) {
        try (SftpConnect sftp = this.pool.borrowObject(this.config);){
            fun.accept(sftp);
        }
        catch (Exception e) {
            throw new SftpClientRunException(e);
        }
    }
}

