/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.Map;
import me.nullaqua.api.awt.BluestarLayoutData;

public class BluestarLayout
implements LayoutManager2 {
    private final Map<Component, BluestarLayoutData> map = new HashMap<Component, BluestarLayoutData>();

    @Override
    @Deprecated
    public void addLayoutComponent(String name, Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Map<Component, BluestarLayoutData> map = this.map;
        synchronized (map) {
            this.map.remove(comp);
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension((this.minimumLayoutSize((Container)parent).width + this.maximumLayoutSize((Container)parent).width) / 2, (this.minimumLayoutSize((Container)parent).height + this.maximumLayoutSize((Container)parent).height) / 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        int width = 0;
        int height = 0;
        Map<Component, BluestarLayoutData> map = this.map;
        synchronized (map) {
            for (Map.Entry<Component, BluestarLayoutData> entry : this.map.entrySet()) {
                BluestarLayoutData data = entry.getValue();
                Component component = entry.getKey();
                Insets insets = data.getInsets();
                int componentWidth = component.getMinimumSize().width + insets.left + insets.right;
                int componentHeight = component.getMinimumSize().height + insets.top + insets.bottom;
                componentHeight *= data.getTotalHeight();
                if ((componentWidth *= data.getTotalWidth()) > width) {
                    width = componentWidth;
                }
                if (componentHeight <= height) continue;
                height = componentHeight;
            }
        }
        return new Dimension(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension maximumLayoutSize(Container target) {
        int width = Integer.MAX_VALUE;
        int height = Integer.MAX_VALUE;
        Map<Component, BluestarLayoutData> map = this.map;
        synchronized (map) {
            for (Map.Entry<Component, BluestarLayoutData> entry : this.map.entrySet()) {
                BluestarLayoutData data = entry.getValue();
                Component component = entry.getKey();
                Insets insets = data.getInsets();
                int componentWidth = component.getMaximumSize().width + insets.left + insets.right;
                int componentHeight = component.getMaximumSize().height + insets.top + insets.bottom;
                componentHeight *= data.getTotalHeight();
                if ((componentWidth *= data.getTotalWidth()) < width) {
                    width = componentWidth;
                }
                if (componentHeight >= height) continue;
                height = componentHeight;
            }
        }
        return new Dimension(width, height);
    }

    @Override
    public void layoutContainer(Container parent) {
        int width = parent.getWidth();
        int height = parent.getHeight();
        for (Component c : parent.getComponents()) {
            double ly;
            double sy;
            double lx;
            double sx;
            if (!this.map.containsKey(c)) continue;
            BluestarLayoutData data = this.map.get(c);
            double dx = (double)width / (double)data.getTotalWidth();
            double dy = (double)height / (double)data.getTotalHeight();
            switch (data.getTransverseAlignment()) {
                case 2: {
                    sx = c.getPreferredSize().getWidth();
                    lx = dx * (double)data.getX() + (double)data.getInsets().left;
                    break;
                }
                case 3: {
                    sx = c.getPreferredSize().getWidth();
                    lx = dx * (double)(data.getX() + data.getWidth()) - (double)data.getInsets().right - sx;
                    break;
                }
                case 1: {
                    sx = c.getPreferredSize().getWidth();
                    lx = (dx * (double)data.getWidth() + (double)data.getInsets().left - (double)data.getInsets().right - sx) / 2.0;
                    lx += dx * (double)data.getX();
                    break;
                }
                default: {
                    sx = dx * (double)(data.getX() + data.getWidth()) - dx * (double)data.getX() - (double)data.getInsets().right - (double)data.getInsets().left;
                    lx = dx * (double)data.getX() + (double)data.getInsets().left;
                }
            }
            switch (data.getPortraitAlignment()) {
                case 2: {
                    sy = c.getPreferredSize().getHeight();
                    ly = dy * (double)data.getY() + (double)data.getInsets().top;
                    break;
                }
                case 3: {
                    sy = c.getPreferredSize().getHeight();
                    ly = dy * (double)(data.getY() + data.getHeight()) - (double)data.getInsets().bottom - sy;
                    break;
                }
                case 1: {
                    sy = c.getPreferredSize().getHeight();
                    ly = (dy * (double)data.getHeight() + (double)data.getInsets().top - (double)data.getInsets().bottom - sy) / 2.0;
                    ly += dy * (double)data.getY();
                    break;
                }
                default: {
                    sy = dy * (double)(data.getY() + data.getHeight()) - dy * (double)data.getY() - (double)data.getInsets().bottom - (double)data.getInsets().top;
                    ly = dy * (double)data.getY() + (double)data.getInsets().top;
                }
            }
            c.setBounds((int)lx, (int)ly, (int)sx, (int)sy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (!(constraints instanceof BluestarLayoutData)) {
            return;
        }
        Map<Component, BluestarLayoutData> map = this.map;
        synchronized (map) {
            this.map.put(comp, (BluestarLayoutData)constraints);
        }
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }
}

