/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.collection;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.RandomAccess;
import org.jetbrains.annotations.NotNull;

public class BitVector
implements Collection<Boolean>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long[] data;
    private long top = -1L;
    private long falseCount = 0L;
    private long trueCount = 0L;

    public BitVector(boolean ... bits) {
        this();
        for (boolean b : bits) {
            this.put(b);
        }
    }

    public BitVector() {
        this.data = new long[1];
    }

    public BitVector(byte ... bits) {
        this.data = new long[(bits.length >>> 3) + 1];
        for (int i = 0; i < bits.length - 7; i += 8) {
            this.data[i >>> 3] = (long)bits[i] & 0xFFL | ((long)bits[i + 1] & 0xFFL) << 8 | ((long)bits[i + 2] & 0xFFL) << 16 | ((long)bits[i + 3] & 0xFFL) << 24 | ((long)bits[i + 4] & 0xFFL) << 32 | ((long)bits[i + 5] & 0xFFL) << 40 | ((long)bits[i + 6] & 0xFFL) << 48 | ((long)bits[i + 7] & 0xFFL) << 56;
        }
        if ((bits.length & 7) > 0) {
            long l = 0L;
            for (int i = bits.length - 1; i >= bits.length - (bits.length & 7); --i) {
                l <<= 8;
                l |= (long)bits[i] & 0xFFL;
            }
            this.data[this.data.length - 1] = l;
        }
        for (long l : this.data) {
            this.trueCount += (long)Long.bitCount(l);
        }
        this.top = ((long)bits.length << 3) - 1L;
        this.falseCount = (long)this.size() - this.trueCount;
    }

    private void expand() {
        if (this.size() < this.data.length << 6) {
            return;
        }
        this.expand(this.data.length << 1);
    }

    @Override
    public int size() {
        return (int)(this.top + 1L);
    }

    private void expand(int size) {
        if (size < this.data.length << 6) {
            return;
        }
        long[] newData = new long[size];
        System.arraycopy(this.data, 0, newData, 0, this.size());
        this.data = newData;
    }

    public BitVector(int ... bits) {
        this.data = new long[(bits.length >>> 1) + 1];
        for (int i = 0; i < bits.length - 1; i += 2) {
            this.data[i >>> 1] = (long)bits[i] & 0xFFFFFFFFL | ((long)bits[i + 1] & 0xFFFFFFFFL) << 32;
        }
        if ((bits.length & 1) == 1) {
            this.data[this.data.length - 1] = (long)bits[bits.length - 1] & 0xFFFFFFFFL;
        }
        for (long l : this.data) {
            this.trueCount += (long)Long.bitCount(l);
        }
        this.top = ((long)bits.length << 5) - 1L;
        this.falseCount = (long)this.size() - this.trueCount;
    }

    public BitVector leftShift(int n) {
        if (n == 0) {
            return this.clone();
        }
        if (n < 0) {
            return this.rightShift(-n);
        }
        int shift = n & 0x3F;
        int shift0 = n >>> 6;
        long[] newData = new long[this.data.length + shift0 + 1];
        System.arraycopy(this.data, 0, newData, shift0, this.data.length);
        if (shift != 0) {
            for (int i = newData.length - 1; i > shift0; --i) {
                int n2 = i;
                newData[n2] = newData[n2] << shift;
                int n3 = i;
                newData[n3] = newData[n3] | newData[i - 1] >>> 64 - shift;
            }
            int n4 = shift0;
            newData[n4] = newData[n4] << shift;
        }
        BitVector bv = new BitVector();
        bv.data = newData;
        bv.top = this.top + (long)n;
        bv.trueCount = this.trueCount;
        bv.falseCount = (long)this.size() - this.trueCount;
        return bv;
    }

    public BitVector(long ... bits) {
        this.data = Arrays.copyOf(bits, bits.length);
        for (long l : bits) {
            this.trueCount += (long)Long.bitCount(l);
        }
        this.top = ((long)bits.length << 6) - 1L;
        this.falseCount = (long)this.size() - this.trueCount;
    }

    public BitVector(BigInteger value) {
        this();
        for (int i = 0; i < value.bitLength(); ++i) {
            this.put(value.testBit(i));
        }
    }

    public long falseCount() {
        return this.falseCount;
    }

    public long trueCount() {
        return this.trueCount;
    }

    public void put(boolean ... bits) {
        for (boolean b : bits) {
            this.put(b);
        }
    }

    public void put(long ... bits) {
        for (long l : bits) {
            for (int i = 0; i < 64; ++i) {
                this.put((l & 1L << i) != 0L);
            }
        }
    }

    public void put(BigInteger value) {
        byte[] bytes;
        for (byte b : bytes = value.toByteArray()) {
            for (int i = 0; i < 8; ++i) {
                this.put((b & 1 << i) != 0);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @NotNull
    public Iterator<Boolean> iterator() {
        return new Iterator<Boolean>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < BitVector.this.size();
            }

            @Override
            public Boolean next() {
                return BitVector.this.get(this.index++);
            }
        };
    }

    public void set(int index, boolean b) {
        if (index >= this.size()) {
            this.expand((index >>> 6) + 1);
            for (int i = this.size(); i < index; ++i) {
                this.put(false);
            }
            this.put(b);
            return;
        }
        if (this.get(index) == b) {
            return;
        }
        if (b) {
            int n = index >>> 6;
            this.data[n] = this.data[n] | 1L << (index & 0x3F);
            ++this.trueCount;
            --this.falseCount;
        } else {
            int n = index >>> 6;
            this.data[n] = this.data[n] & (1L << (index & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
            --this.trueCount;
            ++this.falseCount;
        }
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull @NotNull T @NotNull [] a) {
        if (a.getClass().equals(Boolean[].class)) {
            return this.toArray();
        }
        return null;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public boolean[] toBooleanArray() {
        boolean[] array = new boolean[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Boolean) {
            return this.contains((Boolean)o);
        }
        return false;
    }

    public boolean contains(boolean b) {
        if (b) {
            return this.trueCount > 0L;
        }
        return this.falseCount > 0L;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Boolean> c) {
        for (Boolean bl : c) {
            this.add(bl);
        }
        return true;
    }

    @Override
    public boolean add(Boolean aBoolean) {
        this.put((boolean)aBoolean);
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
        this.data = new long[1];
        this.top = -1L;
        this.falseCount = 0L;
        this.trueCount = 0L;
    }

    @NotNull
    public BigInteger toBigInteger() {
        return new BigInteger(this.toString(), 2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            sb.append(this.get(i) ? (char)'1' : '0');
        }
        return sb.toString();
    }

    public BitVector clone() {
        BitVector bv = new BitVector();
        bv.data = (long[])this.data.clone();
        bv.top = this.top;
        bv.falseCount = this.falseCount;
        bv.trueCount = this.trueCount;
        return bv;
    }

    public void put(boolean b) {
        this.expand();
        if (b) {
            int n = (int)(this.top >>> 6);
            this.data[n] = this.data[n] | 1L << (int)(this.top & 0x3FL);
            ++this.trueCount;
        } else {
            ++this.falseCount;
        }
        ++this.top;
    }

    public boolean get(int index) {
        return (this.data[index >>> 6] & 1L << (index & 0x3F)) != 0L;
    }

    public BitVector rightShift(int n) {
        if (n == 0) {
            return this.clone();
        }
        if (n < 0) {
            return this.leftShift(-n);
        }
        int shift = n & 0x3F;
        int shift0 = n >>> 6;
        if (shift0 >= this.data.length) {
            return new BitVector();
        }
        long[] newData = new long[this.data.length - shift0];
        System.arraycopy(this.data, shift0, newData, 0, this.data.length - shift0);
        BitVector bv = new BitVector();
        bv.data = newData;
        bv.top = this.top - (long)n;
        if (shift != 0) {
            for (int i = 0; i < newData.length - 1; ++i) {
                int n2 = i;
                newData[n2] = newData[n2] >>> shift;
                int n3 = i;
                newData[n3] = newData[n3] | newData[i + 1] << 64 - shift;
            }
            int n4 = newData.length - 1;
            newData[n4] = newData[n4] >>> shift;
        }
        for (long newDatum : newData) {
            bv.trueCount += (long)Long.bitCount(newDatum);
        }
        bv.falseCount = (long)bv.size() - bv.trueCount;
        return bv;
    }

    public void remove() {
        if (this.size() == 0) {
            return;
        }
        if (this.get(this.size() - 1)) {
            --this.trueCount;
        } else {
            --this.falseCount;
        }
        --this.top;
    }

    public BitVector and(BitVector bv) {
        BitVector result = new BitVector();
        int newSize = Math.min(bv.size(), this.size());
        int len = newSize >>> 6;
        int len0 = newSize & 0x3F;
        result.data = new long[len + 1];
        for (int i = 0; i < len; ++i) {
            result.data[i] = this.data[i] & bv.data[i];
            result.trueCount += (long)Long.bitCount(result.data[i]);
        }
        if (len0 != 0) {
            result.data[len] = this.data[len] & bv.data[len] & (1L << len0) - 1L;
            result.trueCount += (long)Long.bitCount(result.data[len]);
        }
        result.falseCount = (long)newSize - result.trueCount;
        result.top = newSize - 1;
        return result;
    }

    public BitVector or(BitVector bv) {
        BitVector result = new BitVector();
        int newSize = Math.max(bv.size(), this.size());
        int len = newSize >>> 6;
        int len0 = newSize & 0x3F;
        result.data = new long[len + 1];
        for (int i = 0; i < len; ++i) {
            result.data[i] = this.data[i] | bv.data[i];
            result.trueCount += (long)Long.bitCount(result.data[i]);
        }
        if (len0 != 0) {
            result.data[len] = this.data[len] | bv.data[len] | (1L << len0) - 1L;
            result.trueCount += (long)Long.bitCount(result.data[len]);
        }
        result.falseCount = (long)newSize - result.trueCount;
        result.top = newSize - 1;
        return result;
    }

    public BitVector xor(BitVector bv) {
        BitVector result = new BitVector();
        int newSize = Math.max(bv.size(), this.size());
        int len = newSize >>> 6;
        int len0 = newSize & 0x3F;
        result.data = new long[len + 1];
        for (int i = 0; i < len; ++i) {
            result.data[i] = this.data[i] ^ bv.data[i];
            result.trueCount += (long)Long.bitCount(result.data[i]);
        }
        if (len0 != 0) {
            result.data[len] = this.data[len] ^ bv.data[len] ^ (1L << len0) - 1L;
            result.trueCount += (long)Long.bitCount(result.data[len]);
        }
        result.falseCount = (long)newSize - result.trueCount;
        result.top = newSize - 1;
        return result;
    }

    public BitVector not() {
        BitVector result = new BitVector();
        int newSize = this.size();
        int len = newSize >>> 6;
        int len0 = newSize & 0x3F;
        result.data = new long[len + 1];
        for (int i = 0; i < len; ++i) {
            result.data[i] = this.data[i] ^ 0xFFFFFFFFFFFFFFFFL;
            result.trueCount += (long)Long.bitCount(result.data[i]);
        }
        if (len0 != 0) {
            result.data[len] = (this.data[len] ^ 0xFFFFFFFFFFFFFFFFL) & (1L << len0) - 1L;
            result.trueCount += (long)Long.bitCount(result.data[len]);
        }
        result.falseCount = (long)newSize - result.trueCount;
        result.top = newSize - 1;
        return result;
    }

    public BitVector andNot(BitVector bv) {
        BitVector result = new BitVector();
        int newSize = Math.max(bv.size(), this.size());
        int len = newSize >>> 6;
        int len0 = newSize & 0x3F;
        result.data = new long[len + 1];
        for (int i = 0; i < len; ++i) {
            result.data[i] = this.data[i] & (bv.data[i] ^ 0xFFFFFFFFFFFFFFFFL);
            result.trueCount += (long)Long.bitCount(result.data[i]);
        }
        if (len0 != 0) {
            result.data[len] = this.data[len] & (bv.data[len] ^ 0xFFFFFFFFFFFFFFFFL) & (1L << len0) - 1L;
            result.trueCount += (long)Long.bitCount(result.data[len]);
        }
        result.falseCount = (long)newSize - result.trueCount;
        result.top = newSize - 1;
        return result;
    }

    public int getMaxSize() {
        return this.data.length << 6;
    }

    public void setMaxSize(int size) {
        if (size < this.size()) {
            throw new IllegalArgumentException("Size: " + size + " is less than current size: " + this.size());
        }
        int newSize = (size >>> 6) + 1;
        if (newSize > this.data.length) {
            long[] newData = new long[newSize];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
    }
}

