/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.collection;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;

public class ByteVector
implements Collection<Byte>,
RandomAccess,
Cloneable,
Serializable {
    private byte[] data;
    private int top = -1;

    public ByteVector() {
        this(1);
    }

    public ByteVector(int size) {
        this.data = new byte[size];
    }

    public void put(byte[] bytes) {
        for (byte b : bytes) {
            this.put(b);
        }
    }

    public void put(byte b) {
        this.expand();
        this.data[++this.top] = b;
    }

    private void expand() {
        if (this.size() < this.data.length) {
            return;
        }
        long length = (long)this.data.length << 1;
        this.setMaxSize(length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length);
    }

    @Override
    public int size() {
        return this.top + 1;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Byte) {
            for (byte b : this) {
                if ((Byte)o != b) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<Byte> iterator() {
        return new Iterator<Byte>(){
            private int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < ByteVector.this.size();
            }

            @Override
            public Byte next() {
                return ByteVector.this.data[this.pos++];
            }
        };
    }

    public Byte[] toArray() {
        byte[] bytes = this.toByteArray();
        Byte[] bts = new Byte[bytes.length];
        for (int i = 1; i < bts.length; ++i) {
            bts[i] = bytes[i];
        }
        return bts;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Byte[] objects = this.toArray();
        if (a.length < this.size()) {
            return Arrays.copyOf(objects, this.size(), a.getClass());
        }
        System.arraycopy(objects, 0, a, 0, this.size());
        if (a.length > this.size()) {
            a[this.size()] = null;
        }
        return a;
    }

    @Override
    public boolean add(Byte aByte) {
        Objects.requireNonNull(aByte);
        this.put(aByte);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Byte> c) {
        for (Byte by : c) {
            this.add(by);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.top = -1;
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[this.size()];
        System.arraycopy(this.data, 0, bytes, 0, this.size());
        return bytes;
    }

    public byte set(int index, byte b) {
        byte res = this.get(index);
        this.data[index] = b;
        return res;
    }

    public byte top() {
        if (this.top >= 0) {
            return this.get(this.top);
        }
        throw new NoSuchElementException();
    }

    public boolean remove() {
        if (this.top >= 0) {
            --this.top;
            return true;
        }
        return false;
    }

    public byte get(int pos) {
        if (pos < 0 || pos >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + pos + " is out of bounds: 0~" + (this.size() - 1));
        }
        return this.data[pos];
    }

    public int getMaxSize() {
        return this.data.length;
    }

    public void setMaxSize(int size) {
        if (size < this.size()) {
            throw new IllegalArgumentException("Size: " + size + " is less than current size: " + this.size());
        }
        byte[] bytes = new byte[size];
        System.arraycopy(this.data, 0, bytes, 0, this.size());
        this.data = bytes;
    }

    public ByteVector clone() {
        ByteVector clone = new ByteVector();
        clone.put(this.toByteArray());
        return clone;
    }

    public OutputStream toOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) {
                ByteVector.this.put((byte)b);
            }
        };
    }

    public InputStream toInputStream() {
        return new InputStream(){
            private int pos = 0;

            @Override
            public int read() {
                if (this.pos < ByteVector.this.size()) {
                    return ByteVector.this.get(this.pos++);
                }
                return -1;
            }
        };
    }
}

