/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import me.nullaqua.api.collection.LinkedDeque;
import org.jetbrains.annotations.NotNull;

public class FastLinkedList<E>
extends LinkedDeque<E>
implements List<E> {
    public FastLinkedList() {
    }

    public FastLinkedList(Collection<E> collection) {
        super(collection);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> c) throws IndexOutOfBoundsException {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException("Can not invoke LinkedList.addAll(),because \"index\" is out of range(0~size)");
        }
        if (index == this.size()) {
            return this.addAll(c);
        }
        LinkedDeque.QueIterator iterator = super.iterator();
        while (index-- > 0) {
            iterator.next();
        }
        for (E e : c) {
            iterator.add(e);
        }
        return true;
    }

    @Override
    public E get(int index) throws IndexOutOfBoundsException {
        if (index >= this.size() || index < 0) {
            throw new IndexOutOfBoundsException("Can not invoke LinkedList.get(),because \"index\" is out of range(0~size)");
        }
        LinkedDeque.QueIterator iterator = super.iterator();
        while (index-- > 0) {
            iterator.next();
        }
        return iterator.next();
    }

    @Override
    public E set(int index, E element) throws IndexOutOfBoundsException {
        if (index >= this.size() || index < 0) {
            throw new IndexOutOfBoundsException("Can not invoke LinkedList.get(),because \"index\" is out of range(0~size)");
        }
        LinkedDeque.QueIterator iterator = super.iterator();
        while (index-- >= 0) {
            iterator.next();
        }
        return super.set(iterator, element);
    }

    @Override
    public void add(int index, E element) throws IndexOutOfBoundsException {
        this.addAll(index, Collections.singletonList(element));
    }

    @Override
    public E remove(int index) throws IndexOutOfBoundsException {
        if (index >= this.size() || index < 0) {
            throw new IndexOutOfBoundsException("Can not invoke LinkedList.get(),because \"index\" is out of range(0~size)");
        }
        LinkedDeque.QueIterator iterator = super.iterator();
        while (index-- > 0) {
            iterator.next();
        }
        Object e = iterator.next();
        iterator.remove();
        return e;
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        return super.iterator();
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        ListIterator<E> iterator = this.listIterator();
        while (index-- > 0) {
            iterator.next();
        }
        return iterator;
    }

    @SafeVarargs
    public static <E> FastLinkedList<E> createList(E ... o) {
        return new FastLinkedList<E>(Arrays.asList(o));
    }

    @Override
    @NotNull
    public FastLinkedList<E> subList(int fromIndex, int toIndex) throws IndexOutOfBoundsException {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("Can not invoke LinkedList.subList(),because \"index\" is out of range");
        }
        FastLinkedList<E> list = new FastLinkedList<E>();
        ListIterator<E> iterator = list.listIterator(fromIndex);
        toIndex -= fromIndex;
        while (toIndex-- > 0) {
            list.addLast(iterator.next());
        }
        return list;
    }
}

