/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import me.nullaqua.api.reflect.MethodAccessor;
import org.jetbrains.annotations.NotNull;

public class LinkedDeque<E>
implements Deque<E>,
Cloneable,
Serializable {
    private Node<E> first;
    private Node<E> last;
    private int size;

    public LinkedDeque(Collection<E> collection) {
        this();
        this.addAll(collection);
    }

    public LinkedDeque() {
        this.clear();
    }

    @Override
    public void addFirst(E e) {
        this.first.insertAfter(e);
        ++this.size;
    }

    @Override
    public void addLast(E e) {
        this.last.insertBefore(e);
        ++this.size;
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E removeFirst() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException("Can not invoke FastDeque.removeFirst(),because the queue is empty.");
        }
        Node<E> node = this.first.getNext();
        E e = node.getVault();
        node.remove();
        --this.size;
        return e;
    }

    @Override
    public E removeLast() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException("Can not invoke FastDeque.removeLast(),because the queue is empty.");
        }
        Node<E> node = this.last.getPrevious();
        E e = node.getVault();
        node.remove();
        --this.size;
        return e;
    }

    @Override
    public E pollFirst() {
        try {
            return this.removeFirst();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public E pollLast() {
        try {
            return this.removeLast();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public E getFirst() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException("Can not invoke FastDeque.getFirst(),because the queue is empty.");
        }
        return this.first.getNext().getVault();
    }

    @Override
    public E getLast() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException("Can not invoke FastDeque.getLast(),because the queue is empty.");
        }
        return this.last.getPrevious().getVault();
    }

    @Override
    public E peekFirst() {
        try {
            return this.getFirst();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public E peekLast() {
        try {
            return this.getLast();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        for (Node<E> node = this.first.getNext(); node != this.last; node = node.getNext()) {
            if (!Objects.equals(o, node.getVault())) continue;
            node.remove();
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        for (Node<E> node = this.last.getPrevious(); node != this.first; node = node.getPrevious()) {
            if (!Objects.equals(o, node.getVault())) continue;
            node.remove();
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        return this.offerLast(e);
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            this.addLast(e);
        }
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        boolean flag = false;
        for (Object object : c) {
            flag |= this.removeAll(object);
        }
        return flag;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        boolean flag = false;
        for (Node<E> node = this.first.getNext(); node != this.last; node = node.getNext()) {
            if (c.contains(node.getVault())) continue;
            node.remove();
            --this.size;
            flag = true;
        }
        return flag;
    }

    public LinkedDeque<E> clone() {
        LinkedDeque deque = new LinkedDeque();
        for (Object e : this) {
            deque.addLast(e);
        }
        return deque;
    }

    @Override
    public void clear() {
        this.first = new Node();
        this.last = new Node();
        this.first.setPrevious(this.first);
        this.first.setNext(this.last);
        this.last.setVault(null);
        this.last.setPrevious(this.first);
        this.last.setNext(this.last);
        this.last.setVault(null);
        this.size = 0;
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    public boolean removeAll(Object o) {
        boolean flag = false;
        for (Node<E> node = this.first.getNext(); node != this.last; node = node.getNext()) {
            if (!Objects.equals(o, node.getVault())) continue;
            node.remove();
            --this.size;
            flag = true;
        }
        return flag;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        boolean flag = true;
        for (Object o : c) {
            flag &= this.contains(o);
        }
        return flag;
    }

    @Override
    public boolean contains(Object o) {
        for (Node<E> node = this.first.getNext(); node != this.last; node = node.getNext()) {
            if (!Objects.equals(o, node.getVault())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size <= 0;
    }

    public QueIterator iterator() {
        return new QueIterator();
    }

    public String toString() {
        Object[] objects = this.toArray();
        for (int i = 0; i < objects.length; ++i) {
            if (this != objects[i]) continue;
            objects[i] = "(this)";
        }
        return Arrays.toString(objects);
    }

    @Override
    @NotNull
    public E[] toArray() {
        Object[] array = new Object[this.size];
        int i = 0;
        for (Object e : this) {
            array[i++] = e;
        }
        return array;
    }

    public LinkedDeque<E> deepClone() throws Throwable {
        LinkedDeque deque = new LinkedDeque();
        for (Object e : this) {
            MethodAccessor methodAccessor = MethodAccessor.getDeclaredMethod(e.getClass(), "clone", new Class[0]);
            methodAccessor.invoke(e, new Object[0]);
            deque.addLast(e);
        }
        return deque;
    }

    @Override
    @NotNull
    public <T> T[] toArray(T @NotNull [] a) {
        E[] objects = this.toArray();
        if (a.length < this.size) {
            return Arrays.copyOf(objects, this.size, a.getClass());
        }
        System.arraycopy(objects, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @NotNull
    public DesQueIterator descendingIterator() {
        return new DesQueIterator();
    }

    @NotNull
    public Iterable<E> descending() {
        return () -> new DesQueIterator();
    }

    @NotNull
    public Iterable<E> ascending() {
        return () -> new QueIterator();
    }

    public void insert(QueIterator iterator, E e) {
        if (iterator.getNode() != this.first) {
            iterator.getNode().insertBefore(e);
            iterator.index++;
            ++this.size;
        }
    }

    public E set(QueIterator iterator, E e) {
        if (iterator.getP() != this.first && iterator.getP() != this.last) {
            return iterator.getP().setVault(e);
        }
        return null;
    }

    public E removeItem(QueIterator iterator) {
        Node node = iterator.getP();
        if (node != null && node != this.first && node != this.last) {
            node.remove();
            --this.size;
            if (iterator.pr > 0) {
                iterator.index--;
            }
            return node.getVault();
        }
        return null;
    }

    public void insert(DesQueIterator iterator, E e) {
        if (iterator.getNode() != this.last) {
            iterator.getNode().insertAfter(e);
            ++this.size;
        }
    }

    public E set(DesQueIterator iterator, E e) {
        if (iterator.getP() != this.first && iterator.getP() != this.last) {
            return iterator.getP().setVault(e);
        }
        return null;
    }

    public E removeItem(DesQueIterator iterator) {
        Node node = iterator.getP();
        if (node != null && node != this.first && node != this.last) {
            node.remove();
            --this.size;
            if (iterator.pr < 0) {
                iterator.index--;
            }
            return node.getVault();
        }
        return null;
    }

    public int indexOf(Object o) {
        int i = 0;
        for (Object e : this) {
            if (Objects.equals(o, e)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        int i = this.size - 1;
        for (E e : this.descending()) {
            if (Objects.equals(o, e)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.size);
        for (Object x : this) {
            out.writeObject(x);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int x = in.readInt();
        this.clear();
        while (x-- > 0) {
            this.add(in.readObject());
        }
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Object e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Collection)) {
            return false;
        }
        QueIterator e1 = this.iterator();
        Iterator e2 = ((Collection)o).iterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o2;
            Object o1 = e1.next();
            if (Objects.equals(o1, o2 = e2.next())) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    private static final class Node<E>
    implements Serializable {
        private E vault;
        private Node<E> previous;
        private Node<E> next;

        public Node(E vault, Node<E> previous, Node<E> next) {
            this.vault = vault;
            this.previous = previous;
            this.next = next;
        }

        public Node() {
            this(null, null, null);
        }

        public E getVault() {
            return this.vault;
        }

        public E setVault(E vault) {
            E v = this.vault;
            this.vault = vault;
            return v;
        }

        public Node<E> getPrevious() {
            return this.previous;
        }

        public void setPrevious(Node<E> previous) {
            this.previous = previous;
        }

        public Node<E> getNext() {
            return this.next;
        }

        public void setNext(Node<E> next) {
            this.next = next;
        }

        public void insertBefore(E e) {
            Node<E> node = new Node<E>(e, this.getPrevious(), this);
            if (this.getPrevious() != null) {
                this.getPrevious().setNext(node);
            }
            this.setPrevious(node);
        }

        public void insertAfter(E e) {
            Node<E> node = new Node<E>(e, this, this.getNext());
            if (this.getNext() != null) {
                this.getNext().setPrevious(node);
            }
            this.setNext(node);
        }

        public void remove() {
            if (this.getPrevious() != null) {
                this.getPrevious().setNext(this.getNext());
            }
            if (this.getNext() != null) {
                this.getNext().setPrevious(this.getPrevious());
            }
        }
    }

    public class QueIterator
    implements ListIterator<E> {
        private Node<E> node;
        private Node<E> p;
        private int index;
        private int pr = 0;

        public QueIterator() {
            this.node = LinkedDeque.this.first.next;
            this.p = null;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.node != LinkedDeque.this.last;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                this.p = this.node;
                this.node = this.node.next;
                this.index = Math.min(this.index + 1, LinkedDeque.this.size);
                this.pr = 1;
                return this.p.vault;
            }
            return null;
        }

        @Override
        public void remove() {
            LinkedDeque.this.removeItem(this);
        }

        @Override
        public void set(E e) {
            LinkedDeque.this.set(this, e);
        }

        private Node<E> getNode() {
            return this.node;
        }

        @Override
        public boolean hasPrevious() {
            return this.node.previous != LinkedDeque.this.first;
        }

        @Override
        public E previous() {
            if (this.hasPrevious()) {
                this.p = this.node.previous;
                this.node = this.node.previous;
                this.index = Math.max(this.index - 1, 0);
                this.pr = -1;
                return this.p.vault;
            }
            return null;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void add(E e) {
            LinkedDeque.this.insert(this, e);
        }

        private Node<E> getP() {
            return this.p;
        }
    }

    public class DesQueIterator
    implements ListIterator<E> {
        int pr = 0;
        private Node<E> node;
        private Node<E> p;
        private int index;

        public DesQueIterator() {
            this.node = LinkedDeque.this.last.previous;
            this.p = null;
            this.index = LinkedDeque.this.size - 1;
        }

        @Override
        public boolean hasNext() {
            return this.node != LinkedDeque.this.first;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                this.p = this.node;
                this.node = this.node.previous;
                this.index = Math.max(this.index - 1, -1);
                this.pr = 1;
                return this.p.vault;
            }
            return null;
        }

        @Override
        public void remove() {
            LinkedDeque.this.removeItem(this);
        }

        @Override
        public void set(E e) {
            LinkedDeque.this.set(this, e);
        }

        private Node<E> getNode() {
            return this.node;
        }

        @Override
        public boolean hasPrevious() {
            return this.node.next != LinkedDeque.this.last;
        }

        @Override
        public E previous() {
            if (this.hasPrevious()) {
                this.p = this.node.next;
                this.node = this.node.next;
                this.index = Math.min(this.index + 1, LinkedDeque.this.size - 1);
                this.pr = -1;
                return this.p.vault;
            }
            return null;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index + 1;
        }

        @Override
        public void add(E e) {
            LinkedDeque.this.insert(this, e);
        }

        private Node<E> getP() {
            return this.p;
        }
    }
}

