/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class LinkedStack<E>
implements Iterable<E> {
    private int size = 0;
    private Node<E> top;

    public LinkedStack() {
        this.clear();
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new StackIterator(this.top);
    }

    @NotNull
    public Object[] toArray() {
        Object[] array = new Object[this.size];
        int i = this.size - 1;
        for (E e : this) {
            array[this.size--] = e;
        }
        return array;
    }

    @NotNull
    public <T> T[] toArray(T[] a) {
        Object[] objects = this.toArray();
        if (a.length < this.size) {
            return Arrays.copyOf(objects, this.size, a.getClass());
        }
        System.arraycopy(objects, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public void push(E e) {
        this.top = new Node(e, this.top);
        ++this.size;
    }

    public void pushAll(@NotNull Collection<? extends E> c) {
        for (E e : c) {
            this.push(e);
        }
    }

    public void clear() {
        this.top = null;
        this.size = 0;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.toArray());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object[] objects = (Object[])in.readObject();
        this.clear();
        for (Object e : objects) {
            this.push(e);
        }
    }

    public static final class StackIterator<E>
    implements Iterator<E> {
        private Node<E> node;

        private StackIterator(Node<E> top) {
            this.node = top;
        }

        @Override
        public boolean hasNext() {
            return this.node != null;
        }

        @Override
        public E next() {
            E e = this.get();
            this.nextOne();
            return e;
        }

        public E get() {
            return this.node != null ? (E)this.node.getVault() : null;
        }

        public void nextOne() {
            this.node = this.node != null ? this.node.getNext() : null;
        }
    }

    private static final class Node<E> {
        private final E vault;
        private final Node<E> next;

        public Node() {
            this.vault = null;
            this.next = this;
        }

        private Node(E vault, Node<E> next) {
            this.vault = vault;
            this.next = next;
        }

        public E getVault() {
            return this.vault;
        }

        public Node<E> getNext() {
            return this.next;
        }
    }
}

