/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.collection;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import me.nullaqua.api.collection.LinkedDeque;
import me.nullaqua.api.reflect.MethodAccessor;
import org.jetbrains.annotations.NotNull;

public class SaveLinkedDeque<E>
extends LinkedDeque<E> {
    private final Lock readLock;
    private final Lock writeLock;

    public SaveLinkedDeque() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    @Override
    public void addFirst(E e) {
        try {
            this.writeLock.lock();
            super.addFirst(e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void addLast(E e) {
        try {
            this.writeLock.lock();
            super.addLast(e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public E removeFirst() throws NoSuchElementException {
        try {
            this.writeLock.lock();
            Object e = super.removeFirst();
            return e;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public E removeLast() throws NoSuchElementException {
        try {
            this.writeLock.lock();
            Object e = super.removeLast();
            return e;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public E getFirst() throws NoSuchElementException {
        try {
            this.readLock.lock();
            Object e = super.getFirst();
            return e;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public E getLast() throws NoSuchElementException {
        try {
            this.readLock.lock();
            Object e = super.getLast();
            return e;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        try {
            this.writeLock.lock();
            boolean bl = super.removeFirstOccurrence(o);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        try {
            this.writeLock.lock();
            boolean bl = super.removeLastOccurrence(o);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        try {
            this.writeLock.lock();
            boolean bl = super.retainAll(c);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void clear() {
        try {
            this.writeLock.lock();
            super.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean removeAll(Object o) {
        try {
            this.writeLock.lock();
            boolean bl = super.removeAll(o);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        try {
            this.readLock.lock();
            boolean bl = super.containsAll(c);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean contains(Object o) {
        try {
            this.readLock.lock();
            boolean bl = super.contains(o);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int size() {
        try {
            this.readLock.lock();
            int n = super.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            this.readLock.lock();
            boolean bl = super.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public SaveQueIterator iterator() {
        return new SaveQueIterator();
    }

    @Override
    public SaveLinkedDeque<E> clone() {
        SaveLinkedDeque deque = new SaveLinkedDeque();
        for (Object e : this) {
            deque.addLast(e);
        }
        return deque;
    }

    @Override
    @NotNull
    public SaveDesQueIterator descendingIterator() {
        return new SaveDesQueIterator();
    }

    @Override
    @NotNull
    public @NotNull E @NotNull [] toArray() {
        try {
            this.writeLock.lock();
            E[] EArray = super.toArray();
            return EArray;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public SaveLinkedDeque<E> deepClone() throws Throwable {
        SaveLinkedDeque deque = new SaveLinkedDeque();
        for (Object e : this) {
            MethodAccessor methodAccessor = MethodAccessor.getDeclaredMethod(e.getClass(), "clone", new Class[0]);
            methodAccessor.invoke(e, new Object[0]);
            deque.addLast(e);
        }
        return deque;
    }

    @Override
    public void insert(LinkedDeque.QueIterator iterator, E e) {
        try {
            this.writeLock.lock();
            super.insert(iterator, e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    @NotNull
    public Iterable<E> descending() {
        return this::descendingIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(LinkedDeque.QueIterator iterator, E e) {
        try {
            this.writeLock.lock();
            E e2 = super.set(iterator, e);
            return e2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public E removeItem(LinkedDeque.QueIterator iterator) {
        try {
            this.writeLock.lock();
            Object e = super.removeItem(iterator);
            return e;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void insert(LinkedDeque.DesQueIterator iterator, E e) {
        try {
            this.writeLock.lock();
            super.insert(iterator, e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(LinkedDeque.DesQueIterator iterator, E e) {
        try {
            this.writeLock.lock();
            E e2 = super.set(iterator, e);
            return e2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public E removeItem(LinkedDeque.DesQueIterator iterator) {
        try {
            this.writeLock.lock();
            Object e = super.removeItem(iterator);
            return e;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public class SaveQueIterator
    extends LinkedDeque.QueIterator {
        @Override
        public E next() {
            try {
                SaveLinkedDeque.this.readLock.lock();
                Object e = super.next();
                return e;
            }
            finally {
                SaveLinkedDeque.this.readLock.unlock();
            }
        }

        @Override
        public E previous() {
            try {
                SaveLinkedDeque.this.readLock.lock();
                Object e = super.previous();
                return e;
            }
            finally {
                SaveLinkedDeque.this.readLock.unlock();
            }
        }
    }

    public class SaveDesQueIterator
    extends LinkedDeque.DesQueIterator {
        @Override
        public E next() {
            try {
                SaveLinkedDeque.this.readLock.lock();
                Object e = super.next();
                return e;
            }
            finally {
                SaveLinkedDeque.this.readLock.unlock();
            }
        }

        @Override
        public E previous() {
            try {
                SaveLinkedDeque.this.readLock.lock();
                Object e = super.previous();
                return e;
            }
            finally {
                SaveLinkedDeque.this.readLock.unlock();
            }
        }
    }
}

