/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import me.nullaqua.api.collection.LinkedStack;
import org.jetbrains.annotations.NotNull;

public class SaveLinkedStack<E>
extends LinkedStack<E> {
    private final Lock readLock;
    private final Lock writeLock;

    public SaveLinkedStack() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    @Override
    public int size() {
        try {
            this.readLock.lock();
            int n = super.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            this.readLock.lock();
            boolean bl = super.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        try {
            this.readLock.lock();
            Iterator iterator = super.iterator();
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    @NotNull
    public Object[] toArray() {
        try {
            this.readLock.lock();
            Object[] objectArray = super.toArray();
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void push(E e) {
        try {
            this.writeLock.lock();
            super.push(e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void pushAll(@NotNull Collection<? extends E> c) {
        try {
            this.writeLock.lock();
            super.pushAll(c);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void clear() {
        try {
            this.writeLock.lock();
            super.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

