/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.collection;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;

public class Vector<E>
implements Collection<E>,
RandomAccess,
Cloneable,
Serializable {
    private E[] data;
    private int top = -1;

    public Vector() {
        this(1);
    }

    public Vector(int size) {
        this.data = new Object[size];
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.top + 1;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < Vector.this.size();
            }

            @Override
            public E next() {
                return Vector.this.data[this.pos++];
            }
        };
    }

    @Override
    public <T> T[] toArray(T[] a) {
        E[] objects = this.toArray();
        if (a.length < this.size()) {
            return Arrays.copyOf(objects, this.size(), a.getClass());
        }
        System.arraycopy(objects, 0, a, 0, this.size());
        if (a.length > this.size()) {
            a[this.size()] = null;
        }
        return a;
    }

    @Override
    public E[] toArray() {
        return Arrays.copyOf(this.data, this.size());
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        if (o != null) {
            for (E b : this) {
                if (!Objects.equals(b, o)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E b : c) {
            this.add(b);
        }
        return true;
    }

    @Override
    public boolean add(E e) {
        Objects.requireNonNull(e);
        this.put(e);
        return true;
    }

    public void put(E b) {
        this.expand();
        this.data[++this.top] = b;
    }

    private void expand() {
        if (this.size() < this.data.length) {
            return;
        }
        this.expand(this.data.length);
    }

    private void expand(int min) {
        if (min < this.data.length) {
            return;
        }
        int x = 1;
        while (min >= this.data.length << x) {
            ++x;
        }
        Object[] newData = new Object[this.data.length << x];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        this.data = newData;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.top = -1;
    }

    public E set(int index, E b) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + " is out of bounds: 0~" + (this.size() - 1));
        }
        this.expand(index);
        E old = this.data[index];
        this.data[index] = b;
        this.top = Math.max(this.top, index);
        return old;
    }

    public E get(int pos) {
        if (pos < 0 || pos >= this.size()) {
            return null;
        }
        return this.data[pos];
    }

    public E top() {
        if (this.top >= 0) {
            return this.get(this.top);
        }
        throw new NoSuchElementException();
    }

    public boolean remove() {
        if (this.top >= 0) {
            --this.top;
            return true;
        }
        return false;
    }

    public int getMaxSize() {
        return this.data.length;
    }

    public void setMaxSize(int size) {
        if (size < this.size()) {
            throw new IllegalArgumentException("Size: " + size + " is less than current size: " + this.size());
        }
        Object[] es = new Object[size];
        System.arraycopy(this.data, 0, es, 0, this.size());
        this.data = es;
    }

    public Vector<E> clone() {
        Vector<E> clone = new Vector<E>();
        clone.put(this.toArray());
        return clone;
    }

    public void put(E[] es) {
        for (E b : es) {
            this.put(b);
        }
    }

    @Override
    public int hashCode() {
        int res = 0;
        for (E b : this) {
            res += b.hashCode();
        }
        return res;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Vector) {
            Vector v = (Vector)obj;
            if (v.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (Objects.equals(v.get(i), this.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(this.get(i));
            if (i == this.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

