/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.collection.overlong;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import me.nullaqua.api.collection.ByteVector;
import me.nullaqua.api.collection.overlong.OverlongVector;
import org.jetbrains.annotations.NotNull;

public final class OverlongBytes
implements OverlongVector<Byte> {
    private final Vector<ByteVector> vector = new Vector();

    @Override
    public long length() {
        if (this.vector.isEmpty()) {
            return 0L;
        }
        return (long)this.vector.lastElement().size() + (long)(this.vector.size() - 1) * Integer.MAX_VALUE;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Byte> c) {
        for (Byte by : c) {
            this.add(by);
        }
        return true;
    }

    @Override
    public boolean add(Byte aByte) {
        this.put(aByte);
        return true;
    }

    public void put(byte b) {
        if (this.vector.isEmpty() || this.vector.lastElement().size() == Integer.MAX_VALUE) {
            ByteVector v = new ByteVector();
            v.setMaxSize(Integer.MAX_VALUE);
            this.vector.add(v);
        }
        this.vector.lastElement().put(b);
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    public Byte get(long index) {
        int i = (int)(index >>> 31);
        int j = (int)(index & Integer.MAX_VALUE);
        return this.vector.get(i).get(j);
    }

    @Override
    public Byte set(long index, Byte element) {
        int i = (int)(index >>> 31);
        int j = (int)(index & Integer.MAX_VALUE);
        return this.vector.get(i).set(j, element);
    }

    public long getMaxSize() {
        if (this.vector.isEmpty()) {
            return 0L;
        }
        return (long)this.vector.lastElement().getMaxSize() + (long)(this.vector.size() - 1) * Integer.MAX_VALUE;
    }

    public OverlongBytes clone() {
        OverlongBytes clone = new OverlongBytes();
        clone.addAll(this);
        return clone;
    }

    public OutputStream toOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) {
                OverlongBytes.this.put((byte)b);
            }
        };
    }

    public InputStream toInputStream() {
        return new InputStream(){
            final Iterator<Byte> iterator;
            {
                this.iterator = OverlongBytes.this.iterator();
            }

            @Override
            public int read() {
                return this.iterator.hasNext() ? (int)this.iterator.next().byteValue() : -1;
            }
        };
    }

    @Override
    @NotNull
    public Iterator<Byte> iterator() {
        return new Iterator<Byte>(){
            private int i = 0;
            private int j = 0;

            @Override
            public boolean hasNext() {
                return this.i < OverlongBytes.this.vector.size() && this.j < ((ByteVector)OverlongBytes.this.vector.get(this.i)).size();
            }

            @Override
            public Byte next() {
                Byte b = ((ByteVector)OverlongBytes.this.vector.get(this.i)).get(this.j);
                if (++this.j == Integer.MAX_VALUE) {
                    ++this.i;
                    this.j = 0;
                }
                return b;
            }
        };
    }
}

