/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.command;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.nullaqua.api.command.Get;
import me.nullaqua.api.command.ParseCommand;
import me.nullaqua.api.command.ParseTab;
import me.nullaqua.api.command.cmdinfo.Args;
import me.nullaqua.api.command.cmdinfo.Cmd;
import me.nullaqua.api.command.cmdinfo.Label;
import me.nullaqua.api.command.cmdinfo.Sender;
import me.nullaqua.api.reflect.FieldAccessor;
import me.nullaqua.api.reflect.MethodAccessor;
import org.apache.commons.lang.ClassUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

class ArgsMap {
    private final Map<String, ArgsMap> commandMap = new HashMap<String, ArgsMap>();
    private ArgsMap commandAny;
    private Run res;
    private String[] resParams;
    private Run any;
    private String[] anyParams;

    private static CommandExceptions merge(CommandException e1, CommandException e2) {
        CommandExceptions e = new CommandExceptions();
        if (e1 instanceof CommandExceptions) {
            e.exceptions.addAll(((CommandExceptions)e1).exceptions);
        } else if (e1 != null) {
            e.exceptions.add(e1);
        }
        if (e2 instanceof CommandExceptions) {
            e.exceptions.addAll(((CommandExceptions)e2).exceptions);
        } else if (e2 != null) {
            e.exceptions.add(e2);
        }
        return e;
    }

    private ArgsMap commandAny() {
        if (this.commandAny == null) {
            this.commandAny = new ArgsMap();
        }
        return this.commandAny;
    }

    void add(Run run) {
        this.add(run.parse().split(" +"), run);
    }

    void add(String[] args, Run run) {
        this.add(args, run, 0);
    }

    void add(String[] args, Run run, int index) {
        if (args.length == index) {
            this.res = run;
            this.resParams = args;
            return;
        }
        String arg = args[index];
        if (arg.equals("...")) {
            this.any = run;
            this.anyParams = Arrays.copyOfRange(args, 0, index);
            return;
        }
        if (arg.startsWith("<") && arg.endsWith(">") || arg.startsWith("[") && arg.endsWith("]")) {
            this.commandAny().add(args, run, index + 1);
        } else {
            ArgsMap map = this.commandMap.get(arg);
            if (map == null) {
                map = new ArgsMap();
                this.commandMap.put(arg.toLowerCase(Locale.ENGLISH), map);
            }
            map.add(args, run, index + 1);
        }
        if (arg.startsWith("[") && arg.endsWith("]")) {
            int i;
            for (i = index + 1; i < args.length && args[i].startsWith("[") && args[i].endsWith("]"); ++i) {
            }
            String[] newArgs = new String[index + args.length - i];
            System.arraycopy(args, 0, newArgs, 0, index);
            System.arraycopy(args, i, newArgs, index, args.length - i);
            this.add(newArgs, run, index);
        }
    }

    Object run(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) throws CommandException {
        return this.run(sender, command, label, args, 0);
    }

    Object run(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args, int index) throws CommandException {
        CommandException exceptions = null;
        if (args.length == index) {
            if (this.res != null) {
                try {
                    return this.tryRun(sender, command, label, args, this.res, this.resParams);
                }
                catch (CommandException e) {
                    exceptions = e;
                }
            }
            if (this.any != null) {
                try {
                    return this.tryRun(sender, command, label, args, this.any, this.anyParams);
                }
                catch (CommandException e) {
                    exceptions = ArgsMap.merge(exceptions, e);
                }
            }
            if (exceptions == null) {
                exceptions = new CommandCanNotMatchException();
            }
            throw exceptions;
        }
        ArgsMap map = this.commandMap.get(args[index].toLowerCase(Locale.ENGLISH));
        if (map != null) {
            try {
                return map.run(sender, command, label, args, index + 1);
            }
            catch (CommandException e) {
                exceptions = ArgsMap.merge(exceptions, e);
            }
        }
        try {
            return this.commandAny().run(sender, command, label, args, index + 1);
        }
        catch (CommandException e) {
            exceptions = ArgsMap.merge(exceptions, e);
            if (this.any != null) {
                try {
                    return this.tryRun(sender, command, label, args, this.any, this.anyParams);
                }
                catch (CommandException e2) {
                    exceptions = ArgsMap.merge(exceptions, e2);
                }
            }
            if (exceptions == null) {
                exceptions = new CommandCanNotMatchException();
            }
            throw exceptions;
        }
    }

    Object tryRun(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args, @NotNull Run run, @NotNull String[] format) throws CommandException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < Math.min(args.length, format.length); ++i) {
            if (format[i].startsWith("<") && format[i].endsWith(">") || format[i].startsWith("[") && format[i].endsWith("]")) {
                String key = format[i].substring(1, format[i].length() - 1);
                if (key.isEmpty()) continue;
                map.put(key, args[i]);
                continue;
            }
            if (format[i].equals("...")) {
                map.put("...", String.join((CharSequence)" ", Arrays.copyOfRange(args, i, args.length)));
                continue;
            }
            if (format[i].equals(args[i])) continue;
            throw new CommandCanNotMatchException();
        }
        if (run.permission != null && !sender.hasPermission(run.permission)) {
            throw new CommandException(run, "The sender doesn't has permission");
        }
        if (run.only != null && run.only.length != 0) {
            boolean flag = false;
            for (Class<?> c : run.only) {
                if (!c.isInstance(sender)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                throw new CommandException(run, "The sender type does not meet the requirements");
            }
        }
        Object[] params = this.getArgs(sender, command, label, args, run, map);
        return run.invoke(params);
    }

    private Object[] getArgs(CommandSender sender, Command command, String label, String[] args, Run r, Map<String, String> map) {
        Object[] params = new Object[r.getParameters().length];
        int i = 0;
        for (Parameter param : r.getParameters()) {
            Object o;
            String key;
            Get fromCommand = param.getAnnotation(Get.class);
            String string = key = fromCommand != null ? fromCommand.value() : "";
            if (param.getAnnotation(Sender.class) != null) {
                o = this.saveCase(param.getType(), sender);
                params[i] = o != null ? o : this.getArg(sender.toString(), param.getType());
            } else if (param.getAnnotation(Cmd.class) != null) {
                o = this.saveCase(param.getType(), command);
                params[i] = o != null ? o : this.getArg(command.toString(), param.getType());
            } else if (param.getAnnotation(Label.class) != null) {
                o = this.saveCase(param.getType(), label);
                params[i] = o != null ? o : this.getArg(label, param.getType());
            } else if (param.getAnnotation(Args.class) != null) {
                if (param.getType().isArray()) {
                    Object arr = Array.newInstance(param.getType().getComponentType(), args.length);
                    for (int j = 0; j < args.length; ++j) {
                        Array.set(arr, j, this.getArg(args[j], param.getType().getComponentType()));
                    }
                    params[i] = arr;
                } else {
                    params[i] = param.getType().isAssignableFrom(List.class) ? Arrays.asList(args) : (param.getType().isAssignableFrom(Set.class) ? new HashSet<String>(Arrays.asList(args)) : this.getArg(String.join((CharSequence)" ", args), param.getType()));
                }
            } else if (fromCommand != null) {
                if (key.equals("...")) {
                    String[] s = map.get("...").split(" ");
                    if (param.getType().isArray()) {
                        Object arr = Array.newInstance(param.getType().getComponentType(), s.length);
                        for (int j = 0; j < s.length; ++j) {
                            Array.set(arr, j, this.getArg(s[j], param.getType().getComponentType()));
                        }
                        params[i] = arr;
                    } else {
                        params[i] = param.getType().isAssignableFrom(List.class) ? Arrays.asList(s) : (param.getType().isAssignableFrom(Set.class) ? new HashSet<String>(Arrays.asList(s)) : this.getArg(map.get("..."), param.getType()));
                    }
                } else {
                    params[i] = this.getArg(map.get(key), param.getType());
                }
            } else {
                params[i] = this.getArg(null, param.getType());
            }
            ++i;
        }
        return params;
    }

    private <T> T saveCase(Class<T> c, Object o) {
        try {
            return c.cast(o);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private Object getArg(String arg, Class<?> c) {
        if (arg == null) {
            if (c.isPrimitive()) {
                if (c == Integer.TYPE) {
                    return -1;
                }
                if (c == Long.TYPE) {
                    return -1L;
                }
                if (c == Short.TYPE) {
                    return (short)-1;
                }
                if (c == Byte.TYPE) {
                    return (byte)-1;
                }
                if (c == Float.TYPE) {
                    return Float.valueOf(-1.0f);
                }
                if (c == Double.TYPE) {
                    return -1.0;
                }
                if (c == Boolean.TYPE) {
                    return false;
                }
                if (c == Character.TYPE) {
                    return Character.valueOf('\u0000');
                }
            }
            return null;
        }
        if (c.isArray()) {
            String[] args = arg.split("/");
            Object array = Array.newInstance(c.getComponentType(), args.length);
            for (int i = 0; i < args.length; ++i) {
                Array.set(array, i, this.getArg(args[i], c.getComponentType()));
            }
            return array;
        }
        if (c.isAssignableFrom(List.class)) {
            String[] args = arg.split("/");
            ArrayList<Object> list = new ArrayList<Object>();
            for (String s : args) {
                list.add(this.getArg(s, c.getComponentType()));
            }
            return list;
        }
        if (c.isAssignableFrom(Set.class)) {
            String[] args = arg.split("/");
            HashSet<Object> set = new HashSet<Object>();
            for (String s : args) {
                set.add(this.getArg(s, c.getComponentType()));
            }
            return set;
        }
        if (c.isPrimitive()) {
            Object o = this.getArg(arg, ClassUtils.primitiveToWrapper(c));
            if (o == null) {
                return this.getArg(null, c);
            }
            return o;
        }
        if (c == String.class) {
            return arg;
        }
        if (c == Integer.class) {
            try {
                return Integer.parseInt(arg);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (c == Long.class) {
            try {
                return Long.parseLong(arg);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (c == Short.class) {
            try {
                return Short.parseShort(arg);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (c == Byte.class) {
            try {
                return Byte.parseByte(arg);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (c == Float.class) {
            try {
                return Float.valueOf(Float.parseFloat(arg));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (c == Double.class) {
            try {
                return Double.parseDouble(arg);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (c == Boolean.class) {
            return "true".equalsIgnoreCase(arg);
        }
        if (c == Character.class) {
            return Character.valueOf(arg.charAt(0));
        }
        if (c == Player.class || c == OfflinePlayer.class) {
            OfflinePlayer offlinePlayer;
            try {
                UUID uuid = UUID.fromString(arg);
                offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
            }
            catch (IllegalArgumentException e) {
                offlinePlayer = Bukkit.getOfflinePlayer((String)arg);
            }
            Player player = offlinePlayer.getPlayer();
            return player != null ? player : (c == Player.class ? null : offlinePlayer);
        }
        if (World.class.isAssignableFrom(c)) {
            try {
                return this.saveCase(c, Bukkit.getWorld((UUID)UUID.fromString(arg)));
            }
            catch (IllegalArgumentException e) {
                return this.saveCase(c, Bukkit.getWorld((String)arg));
            }
        }
        if (Entity.class.isAssignableFrom(c)) {
            try {
                return this.saveCase(c, Bukkit.getEntity((UUID)UUID.fromString(arg)));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        if (c == UUID.class) {
            try {
                return UUID.fromString(arg);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        if (c == Material.class) {
            return Material.matchMaterial((String)arg);
        }
        if (c == Location.class) {
            String[] split = arg.split("/");
            World world = null;
            if (split.length == 4) {
                try {
                    world = Bukkit.getWorld((UUID)UUID.fromString(split[0]));
                    if (world == null) {
                        throw new IllegalArgumentException();
                    }
                }
                catch (IllegalArgumentException e) {
                    world = Bukkit.getWorld((String)split[0]);
                }
            } else if (split.length != 3) {
                return null;
            }
            try {
                double x = Double.parseDouble(split[1]);
                double y = Double.parseDouble(split[2]);
                double z = Double.parseDouble(split[3]);
                return new Location(world, x, y, z);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (c == EntityType.class) {
            return EntityType.fromName((String)arg);
        }
        if (c == Enchantment.class) {
            return Enchantment.getByName((String)arg);
        }
        if (c == PotionEffectType.class) {
            return PotionEffectType.getByName((String)arg);
        }
        if (c == Color.class) {
            String[] split = arg.split("/");
            if (split.length != 3) {
                return null;
            }
            try {
                int r = Integer.parseInt(split[0]);
                int g = Integer.parseInt(split[1]);
                int b = Integer.parseInt(split[2]);
                return Color.fromRGB((int)r, (int)g, (int)b);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (c == Particle.class) {
            return Particle.valueOf((String)arg);
        }
        if (c == Sound.class) {
            return Sound.valueOf((String)arg);
        }
        if (c == BlockFace.class) {
            return BlockFace.valueOf((String)arg);
        }
        if (c == DyeColor.class) {
            return DyeColor.valueOf((String)arg);
        }
        if (c.isEnum()) {
            for (Object o : c.getEnumConstants()) {
                if (!o.toString().equalsIgnoreCase(arg)) continue;
                return o;
            }
            return null;
        }
        return null;
    }

    static class CommandException
    extends Exception {
        public CommandException(Run run, Throwable cause) {
            super(run != null ? run.toString() : "global", cause);
        }

        public CommandException(Run run, String message) {
            super((String)(run != null ? run.toString() : "global: " + message));
        }

        public CommandException(String message) {
            this(null, message);
        }

        public CommandException(Throwable cause) {
            this((Run)null, cause);
        }

        public CommandExceptions toCommandExceptions() {
            if (this instanceof CommandExceptions) {
                return (CommandExceptions)this;
            }
            return ArgsMap.merge(null, this);
        }
    }

    static class CommandExceptions
    extends CommandException {
        Set<CommandException> exceptions = new HashSet<CommandException>();

        public CommandExceptions() {
            super("There are some errors in the command");
        }

        @Override
        public void printStackTrace() {
            this.printStackTrace(System.err);
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            s.println("There are " + this.exceptions.size() + " errors in the command");
            for (CommandException e : this.exceptions) {
                s.println("Caused by: " + e.getMessage());
            }
        }

        @Override
        public void printStackTrace(PrintStream s) {
            this.printStackTrace(new PrintWriter(s));
        }

        public boolean print() {
            if (this.exceptions.isEmpty()) {
                System.err.println("Unknown error");
                return false;
            }
            System.err.println("There are " + this.exceptions.size() + " errors in the command");
            for (CommandException e : this.exceptions) {
                System.err.println("Caused by: " + e.getMessage());
            }
            return true;
        }
    }

    protected static class Run {
        final MethodAccessor method;
        final FieldAccessor field;
        final String format;
        final String permission;
        final Class<?>[] only;
        final boolean isTab;
        final Object instance;

        public Run(Method method, String format, String permission, Class<?>[] only, boolean isTab, Object instance) {
            this.method = new MethodAccessor(method);
            this.instance = instance;
            this.field = null;
            this.format = Run.parseFormat(format);
            this.permission = permission;
            this.only = only;
            this.isTab = isTab;
        }

        public Run(Field field, String format, String permission, Class<?>[] only, boolean isTab, Object instance) {
            this.instance = instance;
            this.method = null;
            this.field = new FieldAccessor(field);
            this.format = Run.parseFormat(format);
            this.permission = permission;
            this.only = only;
            this.isTab = isTab;
        }

        static String parseFormat(String s) {
            return String.join((CharSequence)" ", s.trim().split(" +"));
        }

        public static Run[] of(Method method, ParseCommand[] x, Object instance, String p) {
            Run[] res = new Run[x.length];
            for (int i = 0; i < x.length; ++i) {
                res[i] = new Run(method, p + " " + x[i].value(), x[i].permission(), x[i].only(), false, instance);
            }
            return res;
        }

        public static Run[] of(Method field, ParseTab[] x, Object instance, String p) {
            Run[] res = new Run[x.length];
            for (int i = 0; i < x.length; ++i) {
                res[i] = new Run(field, p + " " + x[i].value(), x[i].permission(), x[i].only(), true, instance);
            }
            return res;
        }

        public static Run[] of(Field field, ParseTab[] x, Object instance, String p) {
            Run[] res = new Run[x.length];
            for (int i = 0; i < x.length; ++i) {
                res[i] = new Run(field, p + " " + x[i].value(), x[i].permission(), x[i].only(), true, instance);
            }
            return res;
        }

        public static Run[] of(Field field, ParseCommand[] x, Object instance, String p) {
            Run[] res = new Run[x.length];
            for (int i = 0; i < x.length; ++i) {
                res[i] = new Run(field, p + " " + x[i].value(), x[i].permission(), x[i].only(), false, instance);
            }
            return res;
        }

        public Parameter[] getParameters() {
            if (this.method != null) {
                return this.method.getMethod().getParameters();
            }
            return new Parameter[0];
        }

        public Object invoke(Object ... args) throws CommandException {
            try {
                if (this.method != null) {
                    return this.method.invoke(this.instance, args);
                }
                if (this.field != null) {
                    return this.field.get(this.instance);
                }
                return null;
            }
            catch (Throwable e) {
                throw new CommandException(this, e);
            }
        }

        public boolean isMethod() {
            return this.method != null;
        }

        public boolean isField() {
            return this.field != null;
        }

        public int hashCode() {
            return this.method != null ? this.method.hashCode() : (this.field != null ? this.field.hashCode() : 0);
        }

        public String toString() {
            return this.method != null ? this.method.getMethod().toString() : (this.field != null ? this.field.getField().toString() : "");
        }

        public boolean equals(Object obj) {
            if (obj instanceof Run) {
                Run run = (Run)obj;
                return this.method != null ? this.method.equals(run.method) : this.field != null && this.field.equals(run.field);
            }
            return false;
        }

        public String parse() {
            return this.format;
        }

        public String permission() {
            return this.permission;
        }

        public Class<?>[] only() {
            return this.only;
        }
    }

    static class CommandCanNotMatchException
    extends CommandException {
        public CommandCanNotMatchException() {
            super("Can't match command");
        }
    }
}

