/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.command;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.nullaqua.api.command.ArgsMap;
import me.nullaqua.api.command.ParseCommand;
import me.nullaqua.api.command.ParseCommands;
import me.nullaqua.api.command.ParseTab;
import me.nullaqua.api.command.ParseTabs;
import me.nullaqua.api.command.SubCommand;
import me.nullaqua.api.command.SubCommands;
import me.nullaqua.api.util.StringsUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.jetbrains.annotations.NotNull;

public final class CommandHandler
implements CommandExecutor,
TabExecutor {
    private final ArgsMap commandMap = new ArgsMap();
    private final ArgsMap tabMap = new ArgsMap();

    private void add(ArgsMap.Run[] run) {
        for (ArgsMap.Run r : run) {
            if (r.isTab) {
                this.tabMap.add(r);
                continue;
            }
            this.commandMap.add(r);
        }
    }

    void add(Object instance) {
        this.add(instance, instance.getClass());
    }

    private void add(@NotNull Object instance, @NotNull Class<?> c) {
        SubCommand subCommand = c.getAnnotation(SubCommand.class);
        SubCommands subCommands = c.getAnnotation(SubCommands.class);
        if (subCommand != null) {
            this.add(instance, c, subCommand.value());
        }
        if (subCommands != null) {
            for (SubCommand subCommand1 : subCommands.value()) {
                this.add(instance, c, subCommand1.value());
            }
        }
        if (subCommands == null && subCommand == null) {
            this.add(instance, c, "");
        }
    }

    private void add(@NotNull Object instance, @NotNull Class<?> c, String head) {
        ParseTab parseTab1;
        ParseCommand parseCommand1;
        ParseTabs parseTab;
        ParseCommands parseCommand;
        Objects.requireNonNull(c);
        Objects.requireNonNull(instance);
        for (Method method : c.getDeclaredMethods()) {
            parseCommand = method.getAnnotation(ParseCommands.class);
            parseTab = method.getAnnotation(ParseTabs.class);
            parseCommand1 = method.getAnnotation(ParseCommand.class);
            parseTab1 = method.getAnnotation(ParseTab.class);
            if (parseCommand != null) {
                this.add(ArgsMap.Run.of(method, parseCommand.value(), instance, head));
            }
            if (parseTab != null) {
                this.add(ArgsMap.Run.of(method, parseTab.value(), instance, head));
            }
            if (parseCommand1 != null) {
                this.add(ArgsMap.Run.of(method, new ParseCommand[]{parseCommand1}, instance, head));
            }
            if (parseTab1 == null) continue;
            this.add(ArgsMap.Run.of(method, new ParseTab[]{parseTab1}, instance, head));
        }
        for (AccessibleObject accessibleObject : c.getDeclaredFields()) {
            parseCommand = ((Field)accessibleObject).getAnnotation(ParseCommands.class);
            parseTab = ((Field)accessibleObject).getAnnotation(ParseTabs.class);
            parseCommand1 = ((Field)accessibleObject).getAnnotation(ParseCommand.class);
            parseTab1 = ((Field)accessibleObject).getAnnotation(ParseTab.class);
            if (parseCommand != null) {
                this.add(ArgsMap.Run.of((Field)accessibleObject, parseCommand.value(), instance, head));
            }
            if (parseTab != null) {
                this.add(ArgsMap.Run.of((Field)accessibleObject, parseTab.value(), instance, head));
            }
            if (parseCommand1 != null) {
                this.add(ArgsMap.Run.of((Field)accessibleObject, new ParseCommand[]{parseCommand1}, instance, head));
            }
            if (parseTab1 == null) continue;
            this.add(ArgsMap.Run.of((Field)accessibleObject, new ParseTab[]{parseTab1}, instance, head));
        }
        if (c.getSuperclass() != Object.class && c.getSuperclass() != null) {
            this.add(instance, c.getSuperclass());
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        try {
            Object res = this.commandMap.run(sender, command, label, args);
            if (res instanceof Boolean) {
                return (Boolean)res;
            }
            if (res == null) {
                return true;
            }
            StringsUtils.toStrings(res).forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
            return true;
        }
        catch (ArgsMap.CommandException e) {
            sender.sendMessage(ChatColor.RED + "Unknown command or has an error when running command.");
            return e.toCommandExceptions().print();
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        try {
            Object res = this.tabMap.run(sender, command, alias, args);
            if (res == null) {
                return Collections.emptyList();
            }
            return StringsUtils.toStrings(res);
        }
        catch (Throwable e) {
            return Collections.emptyList();
        }
    }
}

