/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import me.nullaqua.api.command.CommandAlia;
import me.nullaqua.api.command.CommandAlias;
import me.nullaqua.api.command.CommandHandler;
import me.nullaqua.api.command.CommandManager;
import me.nullaqua.api.command.CommandName;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class CommandHelper {
    private final CommandHandler executor = new CommandHandler();
    private String permission = null;

    public static PluginCommand fastCreateCommand(JavaPlugin plugin, Object o) {
        CommandAlia alia;
        if (o instanceof Class) {
            return CommandHelper.fastCreateCommand(plugin, (Class)o);
        }
        CommandHelper helper = new CommandHelper();
        helper.add(o);
        CommandName commandName = o.getClass().getAnnotation(CommandName.class);
        CommandAlias aliases = o.getClass().getAnnotation(CommandAlias.class);
        ArrayList<String> alias = new ArrayList<String>();
        if (aliases != null) {
            Arrays.stream(aliases.value()).map(CommandAlia::value).forEach(alias::add);
        }
        if ((alia = o.getClass().getAnnotation(CommandAlia.class)) != null) {
            alias.add(alia.value());
        }
        if (commandName == null) {
            throw new IllegalArgumentException("Class " + o.getClass().getName() + " don't have annotation " + CommandName.class.getName());
        }
        return helper.createCommand(plugin, commandName.value(), alias.toArray(new String[0]), commandName.permission());
    }

    public CommandExecutor toCommandExecutor() {
        return this.executor;
    }

    public CommandHelper add(Object instance) {
        this.executor.add(instance);
        return this;
    }

    public static CommandExecutor fastCreateCommandExecutor(Object o) {
        return new CommandHelper().add(o).toCommandExecutor();
    }

    public PluginCommand createCommand(JavaPlugin plugin, String name, String[] aliases, String permission) {
        Objects.requireNonNull(plugin);
        Objects.requireNonNull(name);
        if (permission.isEmpty()) {
            permission = null;
        }
        if (aliases == null) {
            aliases = new String[]{};
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Command name can't be empty");
        }
        PluginCommand command = plugin.getCommand(name);
        if (command == null) {
            command = CommandManager.newPluginCommand(name, (Plugin)plugin);
        }
        if (command == null) {
            throw new IllegalArgumentException("Plugin don't have command " + name + ",and can't create it");
        }
        command.setAliases(Arrays.asList(aliases));
        command.setExecutor(this.toCommandExecutor());
        command.setPermission(permission);
        return command;
    }

    public TabExecutor toTabExecutor() {
        return this.executor;
    }

    public CommandExecutor toExecutor() {
        return this.executor;
    }

    public CommandHelper permission(String permission) {
        this.permission = permission;
        return this;
    }

    public String permission() {
        return this.permission;
    }
}

